/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance(HighlightDisplayKey.class);
    private static final Map<String, HighlightDisplayKey> ourNameToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<HighlightDisplayKey, Computable<String>> ourKeyToDisplayNameMap = new ConcurrentHashMap<HighlightDisplayKey, Computable<String>>();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new ConcurrentHashMap<HighlightDisplayKey, String>();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls @NotNull String name) {
        return ourNameToKeyMap.get(name);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        HighlightDisplayKey key = ourIdToKeyMap.get(id);
        if (key != null) {
            return key;
        }
        key = HighlightDisplayKey.find(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name) {
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        return new HighlightDisplayKey(name, name);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName) {
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName) {
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName, @NotNull @NonNls String id) {
        return HighlightDisplayKey.register(name, (Computable<String>)new Computable.PredefinedValueComputable((Object)displayName), id);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NotNull @NonNls String id) {
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NonNls @NotNull String id, @NonNls @Nullable String alternativeID) {
        HighlightDisplayKey key = HighlightDisplayKey.register(name, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    public static void unregister(@NotNull String shortName) {
        HighlightDisplayKey key = ourNameToKeyMap.remove(shortName);
        if (key != null) {
            ourIdToKeyMap.remove(key.myID);
            ourKeyToAlternativeIDMap.remove(key);
            ourKeyToDisplayNameMap.remove(key);
        }
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName) {
        return HighlightDisplayKey.findOrRegister(name, displayName, null);
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName, @NonNls @Nullable String id) {
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key == null) {
            key = HighlightDisplayKey.register(name, displayName, id != null ? id : name);
            assert (key != null) : name;
        }
        return key;
    }

    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : (String)computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        return ourKeyToAlternativeIDMap.get(key);
    }

    public HighlightDisplayKey(@NonNls @NotNull String name, @NonNls @NotNull String ID2) {
        this.myName = name;
        this.myID = ID2;
        ourNameToKeyMap.put(this.myName, this);
        if (!Objects.equals(ID2, name)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getID() {
        return this.myID;
    }
}

