/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.codeInsight.completion.CompletionExtension;
import com.intellij.codeInsight.completion.CompletionIgnoreDumbnessEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor {
    public static final ExtensionPointName<CompletionContributorEP> EP = new ExtensionPointName("com.intellij.completion.contributor");
    private final MultiMap<CompletionType, Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>> myMap = new MultiMap();
    private static final LanguageExtension<CompletionContributor> INSTANCE = new CompletionExtension<CompletionContributor>(EP.getName());

    public final void extend(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, CompletionProvider<CompletionParameters> provider) {
        this.myMap.putValue((Object)type, (Object)new Pair(place, provider));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        ProcessingContext context;
        for (Pair pair : this.myMap.get((Object)parameters.getCompletionType())) {
            ProgressManager.checkCanceled();
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
        for (Pair pair : this.myMap.get(null)) {
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
    }

    @Deprecated
    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String advertise(@NotNull CompletionParameters parameters) {
        return null;
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        return null;
    }

    @Deprecated
    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        return false;
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
    }

    @NotNull
    public static List<CompletionContributor> forParameters(@NotNull CompletionParameters parameters) {
        return (List)ReadAction.compute(() -> {
            PsiElement position = parameters.getPosition();
            return CompletionContributor.forLanguageHonorDumbness(PsiUtilCore.getLanguageAtOffset(position.getContainingFile(), parameters.getOffset()), position.getProject());
        });
    }

    @NotNull
    public static List<CompletionContributor> forLanguage(@NotNull Language language) {
        return INSTANCE.forKey(language);
    }

    @NotNull
    public static List<CompletionContributor> forLanguageHonorDumbness(@NotNull Language language, @NotNull Project project) {
        return CompletionIgnoreDumbnessEP.isIgnoringDumbnessAllowed(language) ? DumbUtil.getInstance(project).filterByDumbAwarenessHonoringIgnoring(CompletionContributor.forLanguage(language)) : DumbService.getInstance(project).filterByDumbAwareness(CompletionContributor.forLanguage(language));
    }
}

