/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.Position;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class CodeFragmentUtil {
    public static Position getPosition(@NotNull PsiElement element, int startOffset, int endOffset) {
        int offset = element.getTextOffset();
        if (offset < startOffset) {
            return Position.BEFORE;
        }
        if (element.getTextOffset() < endOffset) {
            return Position.INSIDE;
        }
        return Position.AFTER;
    }

    public static boolean elementFit(PsiElement element, int start, int end) {
        return element != null && start <= element.getTextOffset() && element.getTextOffset() + element.getTextLength() <= end;
    }
}

