/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanAccessor
extends CodeStyleFieldAccessor<Boolean, Boolean>
implements CodeStyleChoiceList {
    private static final List<String> BOOLEAN_VALS = Arrays.asList("false", "true");

    public BooleanAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Override
    @Nullable
    protected Boolean parseString(@NotNull String string) {
        return "true".equalsIgnoreCase(string);
    }

    @Override
    @Nullable
    protected Boolean fromExternal(@NotNull Boolean extVal) {
        return extVal;
    }

    @Override
    @NotNull
    protected Boolean toExternal(@NotNull Boolean value) {
        return value;
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return BOOLEAN_VALS;
    }

    @Override
    @Nullable
    protected String valueToString(@NotNull Boolean value) {
        return String.valueOf(value);
    }
}

