/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import com.intellij.util.xml.converters.values.CharacterValueConverter;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValueConvertersRegistry {
    private final Map<Condition<Pair<PsiType, GenericDomValue>>, Converter<?>> myConditionConverters = new LinkedHashMap();

    public void registerDefaultConverters() {
        this.registerBooleanConverters();
        this.registerCharacterConverter();
        this.registerNumberValueConverters();
        this.registerClassValueConverters();
    }

    private void registerBooleanConverters() {
        this.registerConverter((Converter<?>)new BooleanValueConverter(false), PsiType.BOOLEAN);
        this.registerConverter((Converter<?>)new BooleanValueConverter(true), Boolean.class);
    }

    public void registerClassValueConverters() {
        this.registerConverter(ClassValueConverter.getClassValueConverter(), (Condition<Pair<PsiType, GenericDomValue>>)((Condition)pair -> {
            PsiClass resolve;
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiClassType && (resolve = ((PsiClassType)psiType).resolve()) != null) {
                return "java.lang.Class".equals(resolve.getQualifiedName());
            }
            return false;
        }));
        this.registerConverter(ClassArrayConverter.getClassArrayConverter(), Class[].class);
    }

    public void registerCharacterConverter() {
        this.registerConverter((Converter<?>)new CharacterValueConverter(false), PsiType.CHAR);
        this.registerConverter((Converter<?>)new CharacterValueConverter(true), Character.class);
    }

    public void registerNumberValueConverters() {
        this.registerConverter((Converter<?>)new NumberValueConverter(Byte.TYPE, false), PsiType.BYTE);
        this.registerConverter((Converter<?>)new NumberValueConverter(Byte.class, true), Byte.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Short.TYPE, false), PsiType.SHORT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Short.class, true), Short.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Integer.TYPE, false), PsiType.INT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Integer.class, true), Integer.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Long.TYPE, false), PsiType.LONG);
        this.registerConverter((Converter<?>)new NumberValueConverter(Long.class, true), Long.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Float.TYPE, false), PsiType.FLOAT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Float.class, true), Float.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Double.TYPE, false), PsiType.DOUBLE);
        this.registerConverter((Converter<?>)new NumberValueConverter(Double.class, true), Double.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(BigDecimal.class, true), BigDecimal.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(BigInteger.class, true), BigInteger.class);
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull PsiType type) {
        this.registerConverter(provider, (Condition<Pair<PsiType, GenericDomValue>>)((Condition)pair -> Comparing.equal((Object)pair.getFirst(), (Object)type)));
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Condition<Pair<PsiType, GenericDomValue>> condition2) {
        this.myConditionConverters.put(condition2, provider);
    }

    @Nullable
    public final Converter<?> getConverter(@NotNull GenericDomValue domValue, @Nullable PsiType type) {
        Pair pair = Pair.create((Object)type, (Object)domValue);
        Converter<?> converter = this.getRegisteredConverter((Pair<PsiType, GenericDomValue>)pair);
        return converter != null ? converter : this.getCustomConverter((Pair<PsiType, GenericDomValue>)pair);
    }

    @Nullable
    protected Converter<?> getCustomConverter(Pair<PsiType, GenericDomValue> pair) {
        return null;
    }

    @Nullable
    protected Converter<?> getRegisteredConverter(Pair<PsiType, GenericDomValue> pair) {
        for (Condition<Pair<PsiType, GenericDomValue>> condition2 : this.myConditionConverters.keySet()) {
            if (!condition2.value(pair)) continue;
            return this.myConditionConverters.get(condition2);
        }
        return null;
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Class type) {
        String name = type.getCanonicalName();
        this.registerConverter(provider, (Condition<Pair<PsiType, GenericDomValue>>)((Condition)pair -> pair.first != null && Objects.equals(name, ((PsiType)pair.first).getCanonicalText())));
    }

    public static interface Provider {
        public Converter getConverter();

        public Condition<Pair<PsiType, GenericDomValue>> getCondition();
    }
}

