/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiReference, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.methodReferencesSearch");
    public static final MethodReferencesSearch INSTANCE = new MethodReferencesSearch();

    private MethodReferencesSearch() {
        super(EP_NAME);
    }

    public static Query<PsiReference> search(@NotNull PsiMethod method, SearchScope scope, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch));
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, @NotNull SearchRequestCollector collector, Processor<? super PsiReference> processor) {
        MethodReferencesSearch.searchOptimized(method, scope, strictSignatureSearch, collector, false, (PairProcessor<? super PsiReference, ? super SearchRequestCollector>)((PairProcessor)(psiReference, collector1) -> processor.process(psiReference)));
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector collector, boolean inReadAction, PairProcessor<? super PsiReference, ? super SearchRequestCollector> processor) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        collector.searchQuery(new QuerySearchRequest(MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch, nested)), nested, inReadAction, processor));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        Query result = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return MethodReferencesSearch.uniqueResults((Query<? extends PsiReference>)result);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)parameters.getMethod());
        return MethodReferencesSearch.uniqueResults((Query<? extends PsiReference>)new MergeQuery(result, (Query)new SearchRequestQuery(project, requests)));
    }

    public static Query<PsiReference> search(PsiMethod method, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(method, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method)), strictSignatureSearch);
    }

    public static Query<PsiReference> search(PsiMethod method) {
        return MethodReferencesSearch.search(method, true);
    }

    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(@NotNull Query<? extends PsiReference> composite) {
        return new UniqueResultsQuery(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters {
        private final PsiMethod myMethod;
        private final Project myProject;
        private final SearchScope myScope;
        private volatile SearchScope myEffectiveScope;
        private final boolean myStrictSignatureSearch;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean strictSignatureSearch, @Nullable SearchRequestCollector optimizer) {
            this.myMethod = method;
            this.myScope = scope;
            this.myStrictSignatureSearch = strictSignatureSearch;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer != null ? optimizer : new SearchRequestCollector(new SearchSession(new PsiElement[]{method}));
            this.myProject = PsiUtilCore.getProjectInReadAction((PsiElement)method);
        }

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean strict) {
            this(method, scope, strict, null);
        }

        public boolean isQueryValid() {
            return this.myMethod.isValid();
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isStrictSignatureSearch() {
            return this.myStrictSignatureSearch;
        }

        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            return this.getScopeDeterminedByUser();
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope scope = this.myEffectiveScope;
            if (scope == null) {
                if (!this.myMethod.isValid()) {
                    return GlobalSearchScope.EMPTY_SCOPE;
                }
                this.myEffectiveScope = scope = this.myScope.intersectWith(PsiSearchHelper.getInstance((Project)this.myMethod.getProject()).getUseScope((PsiElement)this.myMethod));
            }
            return scope;
        }
    }
}

