/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DirectClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiClass, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.directClassInheritorsSearch");
    public static final DirectClassInheritorsSearch INSTANCE = new DirectClassInheritorsSearch();

    private DirectClassInheritorsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        return DirectClassInheritorsSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass)));
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        return DirectClassInheritorsSearch.search(aClass, scope, true);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous) {
        return DirectClassInheritorsSearch.search(new SearchParameters(aClass, scope, includeAnonymous, true));
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    @Deprecated
    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous, boolean checkInheritance) {
        return DirectClassInheritorsSearch.search(aClass, scope, includeAnonymous);
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myIncludeAnonymous;
        private final boolean myCheckInheritance;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous, boolean checkInheritance) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myIncludeAnonymous = includeAnonymous;
            this.myCheckInheritance = checkInheritance;
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean includeAnonymous) {
            this(aClass, scope, includeAnonymous, true);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            this(aClass, scope, true);
        }

        @NotNull
        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean includeAnonymous() {
            return this.myIncludeAnonymous;
        }

        @ApiStatus.Experimental
        public boolean shouldSearchInLanguage(@NotNull Language language2) {
            return true;
        }
    }
}

