/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AbstractQuery;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiClass, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (!parameters.isCheckDeep()) {
            FilteredQuery directQuery = DirectClassInheritorsSearch.search(parameters.getClassToProcess(), parameters.getScope(), parameters.isIncludeAnonymous());
            if (parameters.getNameCondition() != Conditions.alwaysTrue()) {
                directQuery = new FilteredQuery(directQuery, psiClass -> parameters.getNameCondition().value(ReadAction.compute(() -> ((PsiClass)psiClass).getName())));
            }
            return AbstractQuery.wrapInReadAction(directQuery);
        }
        return INSTANCE.createUniqueResultsQuery(parameters, ContainerUtil.canonicalStrategy(), psiClass -> (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass)));
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        DeprecatedMethodException.report((String)"Use ClassInheritorsSearch.search(PsiClass, SearchScope, boolean, boolean, boolean) instead");
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true, true);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, (SearchScope)ReadAction.compute(() -> {
            if (!aClass.isValid()) {
                throw new ProcessCanceledException();
            }
            PsiFile file = aClass.getContainingFile();
            return (file != null ? file : aClass).getUseScope();
        }), checkDeep);
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        return ClassInheritorsSearch.search(aClass, true);
    }

    public static class SearchParameters
    implements QueryParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        @NotNull
        private final Condition<String> myNameCondition;
        @NotNull
        private final Project myProject;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<String>)Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            assert (checkInheritance);
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
            this.myProject = PsiUtilCore.getProjectInReadAction((PsiElement)this.myClass);
        }

        @NotNull
        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        public boolean isQueryValid() {
            return this.myClass.isValid();
        }

        @NotNull
        public Condition<String> getNameCondition() {
            return this.myNameCondition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }

        public String toString() {
            return "'" + this.myClass.getQualifiedName() + "' scope=" + this.myScope + (this.myCheckDeep ? " (deep)" : "") + (this.myCheckInheritance ? " (check inheritance)" : "") + (this.myIncludeAnonymous ? " (anonymous)" : "") + (this.myNameCondition == Conditions.alwaysTrue() ? "" : " condition: " + this.myNameCondition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            if (this.myCheckDeep != that.myCheckDeep) {
                return false;
            }
            if (this.myCheckInheritance != that.myCheckInheritance) {
                return false;
            }
            if (this.myIncludeAnonymous != that.myIncludeAnonymous) {
                return false;
            }
            if (!this.myClass.equals(that.myClass)) {
                return false;
            }
            if (!this.myScope.equals(that.myScope)) {
                return false;
            }
            return this.myNameCondition.equals(that.myNameCondition);
        }

        public int hashCode() {
            int result = this.myClass.hashCode();
            result = 31 * result + this.myScope.hashCode();
            result = 31 * result + (this.myCheckDeep ? 1 : 0);
            result = 31 * result + (this.myCheckInheritance ? 1 : 0);
            result = 31 * result + (this.myIncludeAnonymous ? 1 : 0);
            result = 31 * result + this.myNameCondition.hashCode();
            return result;
        }
    }
}

