/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.jsp.JavaJspElementVisitor;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public abstract class JavaJspRecursiveElementVisitor
extends JavaJspElementVisitor
implements PsiRecursiveVisitor {
    private final Stack<PsiReferenceExpression> myRefExprsInVisit = new Stack();

    public void visitElement(@NotNull PsiElement element) {
        if (!this.myRefExprsInVisit.isEmpty() && this.myRefExprsInVisit.peek() == element) {
            this.myRefExprsInVisit.pop();
            this.myRefExprsInVisit.push(null);
        } else {
            element.acceptChildren((PsiElementVisitor)this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.myRefExprsInVisit.push((Object)expression);
        try {
            this.visitExpression(expression);
            this.visitReferenceElement(expression);
        }
        finally {
            this.myRefExprsInVisit.pop();
        }
    }

    @Override
    public void visitJspFile(JspFile file) {
        super.visitJspFile(file);
        this.visitClass(file.getJavaClass());
        this.visitFile(file.getBaseLanguageRoot());
    }
}

