/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPrimitiveType
extends PsiType.Stub
implements JvmPrimitiveType {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap();
    private final JvmPrimitiveTypeKind myKind;
    private final String myName;

    PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myKind = kind;
        if (kind != null) {
            ourQNameToUnboxed.put(kind.getBoxedFqn(), this);
        }
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, PsiAnnotation @NotNull [] annotations) {
        super(annotations);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, @NotNull TypeAnnotationProvider provider) {
        super(provider);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        super(provider);
        JvmPrimitiveTypeKind kind = JvmPrimitiveTypeKind.getKindByName(name);
        if (kind == null) {
            throw new NoSuchElementException("Cannot find primitive type: " + name);
        }
        this.myKind = kind;
        this.myName = name;
    }

    @Deprecated
    public PsiPrimitiveType(@NotNull String name, PsiAnnotation @NotNull [] annotations) {
        super(annotations);
        this.myKind = null;
        this.myName = name;
    }

    @NotNull
    @Contract(pure=true)
    private static String getName(@Nullable JvmPrimitiveTypeKind kind) {
        return kind == null ? "null" : kind.getName();
    }

    @Override
    @NotNull
    public final JvmPrimitiveTypeKind getKind() {
        return Objects.requireNonNull(this.myKind, "getKind() called on PsiType.NULL\nIf your code works with JvmElement API then this should not happen unless some implementation improperly returns PsiType.NULL from JvmMethod.getReturnType() (or any other available methods).\nIf your code works with PsiType-s then you must check if this type is PsiType.NULL type before calling this method");
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        return (PsiPrimitiveType)super.annotate(provider);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return this.getText(false, annotated);
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(true, annotated);
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText(true);
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type);
        LanguageLevel languageLevel = ((PsiClassType)type).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type.getAnnotationProvider());
    }

    @Nullable
    public static PsiPrimitiveType getOptionallyUnboxedType(PsiType type) {
        return type instanceof PsiPrimitiveType ? (PsiPrimitiveType)type : PsiPrimitiveType.getUnboxedType(type);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiPrimitiveType fromJvmTypeDescriptor(char descriptor) {
        switch (descriptor) {
            case 'B': {
                return PsiType.BYTE;
            }
            case 'C': {
                return PsiType.CHAR;
            }
            case 'D': {
                return PsiType.DOUBLE;
            }
            case 'F': {
                return PsiType.FLOAT;
            }
            case 'Z': {
                return PsiType.BOOLEAN;
            }
            case 'I': {
                return PsiType.INT;
            }
            case 'J': {
                return PsiType.LONG;
            }
            case 'S': {
                return PsiType.SHORT;
            }
        }
        return null;
    }

    @Nullable
    public String getBoxedTypeName() {
        return this.myKind == null ? null : this.myKind.getBoxedFqn();
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file.getProject());
        PsiClass aClass = facade.findClass(boxedQName, file.getResolveScope());
        if (aClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass);
    }

    @Deprecated
    public static Collection<String> getAllBoxedTypeNames() {
        return JvmPrimitiveTypeKind.getBoxedFqns();
    }

    public int hashCode() {
        return this.myKind == null ? 0 : this.myKind.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PsiPrimitiveType && this.myKind == ((PsiPrimitiveType)obj).myKind;
    }
}

