/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmTypeParameter;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class PsiJvmSubstitutor
implements JvmSubstitutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    public PsiJvmSubstitutor(@NotNull Project project, @NotNull PsiSubstitutor substitutor) {
        this.myProject = project;
        this.mySubstitutor = substitutor;
    }

    @Override
    @NotNull
    public Collection<JvmTypeParameter> getTypeParameters() {
        return new SmartList(this.mySubstitutor.getSubstitutionMap().keySet());
    }

    @Override
    @Nullable
    public JvmType substitute(@NotNull JvmTypeParameter typeParameter) {
        JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance(this.myProject);
        PsiTypeParameter psiTypeParameter = helper.convertTypeParameter(typeParameter);
        return this.mySubstitutor.substitute(psiTypeParameter);
    }

    @NotNull
    public PsiSubstitutor getPsiSubstitutor() {
        return this.mySubstitutor;
    }
}

