/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PsiEllipsisType
extends PsiArrayType {
    public PsiEllipsisType(@NotNull PsiType componentType) {
        super(componentType);
    }

    public PsiEllipsisType(@NotNull PsiType componentType, PsiAnnotation @NotNull [] annotations) {
        super(componentType, annotations);
    }

    public PsiEllipsisType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider) {
        super(componentType, provider);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return this.getText(this.getComponentType().getPresentableText(annotated), "...", false, annotated);
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(this.getComponentType().getCanonicalText(annotated), "...", true, annotated);
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return this.getText(this.getComponentType().getInternalCanonicalText(), "...", true, true);
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        return text.endsWith("...") && this.getComponentType().equalsToText(text.substring(0, text.length() - 3)) || super.equalsToText(text);
    }

    @Contract(pure=true)
    @NotNull
    public PsiType toArrayType() {
        return new PsiArrayType(this.getComponentType(), this.getAnnotationProvider());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitEllipsisType(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 5;
    }
}

