/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.actions;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.SimpleExpectedType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface ChangeParametersRequest
extends ActionRequest {
    public List<ExpectedParameter> getExpectedParameters();

    public static class ExistingParameterWrapper
    implements ExpectedParameter {
        private final JvmParameter myExistingParameter;

        public ExistingParameterWrapper(@NotNull JvmParameter existingParameter) {
            this.myExistingParameter = existingParameter;
        }

        @Override
        @NotNull
        public List<ExpectedType> getExpectedTypes() {
            return Collections.singletonList(new SimpleExpectedType(this.myExistingParameter.getType(), ExpectedType.Kind.EXACT));
        }

        @Override
        @NotNull
        public Collection<String> getSemanticNames() {
            return Collections.singletonList(this.myExistingParameter.getName());
        }

        @NotNull
        public JvmParameter getExistingParameter() {
            return this.myExistingParameter;
        }
    }
}

