/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.lang.jvm.source.JvmDeclarationSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmMetaLanguage
extends MetaLanguage {
    protected JvmMetaLanguage() {
        super("JVM");
    }

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        ExtensionPointImpl<LanguageExtensionPoint<JvmDeclarationSearcher>> point = JvmMetaLanguage.getPoint();
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language language2 : Language.getRegisteredLanguages()) {
            if (!(language2 instanceof JvmLanguage) && (point == null || !JvmMetaLanguage.matchesRegisteredLanguage(language2, point))) continue;
            result.add(language2);
        }
        return result;
    }

    public boolean matchesLanguage(@NotNull Language language2) {
        if (language2 instanceof JvmLanguage) {
            return true;
        }
        ExtensionPointImpl<LanguageExtensionPoint<JvmDeclarationSearcher>> point = JvmMetaLanguage.getPoint();
        return point != null && JvmMetaLanguage.matchesRegisteredLanguage(language2, point);
    }

    private static boolean matchesRegisteredLanguage(@NotNull Language language2, @NotNull ExtensionPointImpl<LanguageExtensionPoint<JvmDeclarationSearcher>> point) {
        return ExtensionProcessingHelper.getByKey(point, (Object)language2.getID(), JvmMetaLanguage.class, LanguageExtensionPoint::getKey) != null;
    }

    @Nullable
    private static ExtensionPointImpl<LanguageExtensionPoint<JvmDeclarationSearcher>> getPoint() {
        ExtensionsAreaImpl area = (ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea();
        return area.getExtensionPointIfRegistered(JvmDeclarationSearcher.EP.getName());
    }
}

