/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    abstract List<String> getDefaultNullables();

    @NotNull
    abstract List<String> getDefaultNotNulls();

    @NotNull
    abstract List<String> getAllDefaultAnnotations();

    public static NullableNotNullManager getInstance(Project project) {
        return (NullableNotNullManager)ServiceManager.getService((Project)project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, true);
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(original);
        if (info == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(original);
        if (info == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src = this.findOwnNullabilityInfo(original);
        if (src == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner target) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName != null) {
            PsiModifierList modifierList;
            if (JavaPsiFacade.getInstance(annotation.getProject()).findClass(qualifiedName, target.getResolveScope()) == null) {
                return null;
            }
            if (!AnnotationTargetUtil.isTypeAnnotation(annotation) && (modifierList = target.getModifierList()) != null && !modifierList.hasAnnotation(qualifiedName)) {
                return modifierList.addAnnotation(qualifiedName);
            }
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(owner);
        if (info == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        String qualifiedName = info.getAnnotation().getQualifiedName();
        return qualifiedName != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + qualifiedName, owner) : null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    private PsiAnnotation findNullityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        int flags;
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, checkBases);
        if (annotation != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> annotations = nullable ? this.getDefaultNotNulls() : this.getDefaultNullables();
        if (AnnotationUtil.isAnnotated(owner, annotations, flags = (checkBases ? 1 : 0) | 2 | 4 | 8)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        NullabilityAnnotationInfo nullityDefault = this.findNullityDefaultInHierarchy(owner);
        Nullability wantedNullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULL;
        return nullityDefault != null && nullityDefault.getNullability() == wantedNullability ? nullityDefault.getAnnotation() : null;
    }

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> nullables = this.getNullablesWithNickNames();
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, false);
        if (annotation != null) {
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        return null;
    }

    @Nullable
    public NullabilityAnnotationInfo findExplicitNullability(PsiModifierListOwner owner) {
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, this.getAllNullabilityAnnotationsWithNickNames(), false, true);
        if (annotation != null) {
            Nullability nullability = this.getNullablesWithNickNames().contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL;
            return new NullabilityAnnotationInfo(annotation, nullability, false);
        }
        return this.findNullityDefaultInHierarchy(owner);
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)this.doFindEffectiveNullabilityAnnotation(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        Set<String> annotationNames = this.getAllNullabilityAnnotationsWithNickNames();
        HashSet<String> extraAnnotations = new HashSet<String>(this.getAllDefaultAnnotations());
        extraAnnotations.addAll(annotationNames);
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, extraAnnotations, true, false);
        if (annotation != null) {
            if (!annotationNames.contains(annotation.getQualifiedName())) {
                return null;
            }
            List<String> nullables = this.getNullablesWithNickNames();
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                PsiAnnotation plain = NullableNotNullManager.findPlainAnnotation(parameter, extraAnnotations, false, false);
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo == null) continue;
                return defaultInfo.getNullability() == Nullability.NOT_NULL ? defaultInfo : null;
            }
            return null;
        }
        NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(owner);
        if (!(defaultInfo == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, @NotNull List<? extends PsiParameter> superOwners) {
        return (PsiAnnotation)RecursionManager.doPreventingRecursion((Object)owner, (boolean)true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        Set<String> qNames = this.getAllNullabilityAnnotationsWithNickNames();
        return NullableNotNullManager.findPlainAnnotation(owner, qNames, checkBases, false);
    }

    @Nullable
    public PsiAnnotation findExplicitNullabilityAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Nullability nullability) {
        if (nullability == Nullability.UNKNOWN) {
            return null;
        }
        List<String> names = nullability == Nullability.NULLABLE ? this.getNullablesWithNickNames() : this.getNotNullsWithNickNames();
        return NullableNotNullManager.findPlainAnnotation(owner, new HashSet<String>(names), false, false);
    }

    @Nullable
    private static PsiAnnotation findPlainAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Set<String> qualifiedNames, boolean checkBases, boolean skipExternal) {
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qualifiedNames, skipExternal) : AnnotationUtil.findAnnotation(owner, qualifiedNames, skipExternal);
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null && type instanceof PsiArrayType && AnnotationTargetUtil.isTypeAnnotation(memberAnno)) {
            memberAnno = null;
        }
        if (memberAnno != null) {
            PsiAnnotation annotation = NullableNotNullManager.preferTypeAnnotation(memberAnno, type);
            if (annotation != memberAnno && !qualifiedNames.contains(annotation.getQualifiedName())) {
                return null;
            }
            return annotation;
        }
        if (type instanceof PsiPrimitiveType) {
            return null;
        }
        return AnnotationUtil.findAnnotationInTypeHierarchy(type, qualifiedNames);
    }

    @NotNull
    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type) {
        if (type != null) {
            for (PsiAnnotation typeAnno : type.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                return typeAnno;
            }
        }
        return memberAnno;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, @NotNull PsiAnnotation typeAnno) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(memberAnno.getProject());
        List<String> notNulls = manager.getNotNullsWithNickNames();
        List<String> nullables = manager.getNullablesWithNickNames();
        return nullables.contains(typeAnno.getQualifiedName()) && notNulls.contains(memberAnno.getQualifiedName()) || nullables.contains(memberAnno.getQualifiedName()) && notNulls.contains(typeAnno.getQualifiedName());
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        return this.getNullables();
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        return this.getNotNulls();
    }

    @NotNull
    protected Set<String> getAllNullabilityAnnotationsWithNickNames() {
        HashSet<String> qNames = new HashSet<String>(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        return Collections.unmodifiableSet(qNames);
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    public NullabilityAnnotationInfo findDefaultTypeUseNullability(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        if (context.getParent() instanceof PsiTypeElement && context.getParent().getParent() instanceof PsiLocalVariable) {
            return null;
        }
        return this.findNullabilityDefault(context, PsiAnnotation.TargetType.TYPE_USE);
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        return this.findNullabilityDefault(owner, AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList()));
    }

    @Nullable
    private NullabilityAnnotationInfo findNullabilityDefault(@NotNull PsiElement place, PsiAnnotation.TargetType ... placeTargetTypes) {
        for (PsiElement element = place.getParent(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result;
            if (element instanceof PsiModifierListOwner && (result = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, place, false)) != null) {
                return result;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName), place);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType @NotNull [] placeTargetTypes, @Nullable PsiPackage psiPackage, PsiElement context) {
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, context, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    abstract NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner var1, PsiAnnotation.TargetType @NotNull [] var2, PsiElement var3, boolean var4);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner);
        return info == null ? Nullability.UNKNOWN : info.getNullability();
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullabilityAnnotation(@NotNull PsiAnnotation annotation) {
        return NullableNotNullManager.getInstance(annotation.getProject()).getAllNullabilityAnnotationsWithNickNames().contains(annotation.getQualifiedName());
    }
}

