/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;

public class NullabilityAnnotationInfo {
    @NotNull
    private final PsiAnnotation myAnnotation;
    @NotNull
    private final Nullability myNullability;
    private final boolean myContainer;

    public NullabilityAnnotationInfo(@NotNull PsiAnnotation annotation, @NotNull Nullability nullability, boolean container) {
        this.myAnnotation = annotation;
        this.myNullability = nullability;
        this.myContainer = container;
    }

    @NotNull
    public PsiAnnotation getAnnotation() {
        return this.myAnnotation;
    }

    @NotNull
    public Nullability getNullability() {
        return this.myNullability;
    }

    public boolean isContainer() {
        return this.myContainer;
    }

    public boolean isExternal() {
        return AnnotationUtil.isExternalAnnotation(this.myAnnotation);
    }

    public boolean isInferred() {
        return AnnotationUtil.isInferredAnnotation(this.myAnnotation);
    }

    public String toString() {
        return "NullabilityAnnotationInfo{" + (Object)((Object)this.myNullability) + "(" + this.myAnnotation.getQualifiedName() + ")" + (this.myContainer ? ", container=" : "") + "}";
    }
}

