/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "", "passwordFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getPasswordFile", "()Ljava/nio/file/Path;", "decryptMasterKey", "", "data", "isAutoGenerated", "", "load", "readMasterKeyIsAutoGeneratedMetadata", "save", "", "key", "Lcom/intellij/credentialStore/keePass/MasterKey;", "intellij.platform.credentialStore"})
public final class MasterKeyFileStorage {
    @NotNull
    private final Path passwordFile;

    @Nullable
    public final byte[] load() {
        byte[] data = null;
        boolean isOld = false;
        try {
            data = PathKt.readBytes((Path)this.passwordFile);
        }
        catch (NoSuchFileException e) {
            try {
                data = PathKt.readBytes((Path)this.passwordFile.getParent().resolve("pdb.pwd"));
            }
            catch (NoSuchFileException e2) {
                return null;
            }
            isOld = true;
        }
        try {
            byte[] decrypted = null;
            if (isOld) {
                decrypted = EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(SystemInfo.isWindows).decrypt(data);
                ArraysKt.fill$default((byte[])data, (byte)0, (int)0, (int)0, (int)6, null);
            } else {
                byte[] byArray = this.decryptMasterKey(data);
                if (byArray == null) {
                    return null;
                }
                decrypted = byArray;
            }
            ArraysKt.fill$default((byte[])data, (byte)0, (int)0, (int)0, (int)6, null);
            return decrypted;
        }
        catch (Exception e) {
            String string;
            Logger logger = CredentialStoreKt.getLOG();
            StringBuilder stringBuilder = new StringBuilder().append("Cannot decrypt master key, file content:\n");
            if (isOld) {
                string = Base64.getEncoder().encodeToString(data);
            } else {
                byte[] byArray = data;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                boolean bl2 = false;
                string = new String(byArray, charset);
            }
            logger.warn(stringBuilder.append(string).toString(), (Throwable)e);
            return null;
        }
    }

    private final byte[] decryptMasterKey(byte[] data) {
        Object object;
        byte[] byArray;
        EncryptionType encryptionType = null;
        byte[] value = null;
        for (NodeTuple node : MasterKeyKt.access$createMasterKeyReader(data)) {
            String string;
            Node keyNode = node.getKeyNode();
            Node valueNode = node.getValueNode();
            if (!(keyNode instanceof ScalarNode) || !(valueNode instanceof ScalarNode)) continue;
            if (((ScalarNode)valueNode).getValue() == null) {
                continue;
            }
            if (((ScalarNode)keyNode).getValue() == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case -1512632445: {
                    if (!string.equals("encryption")) break;
                    n = 1;
                    break;
                }
                case 111972721: {
                    if (!string.equals("value")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String propertyValue;
                    String string2 = propertyValue;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                    encryptionType = EncryptionType.valueOf(string4);
                    break;
                }
                case 2: {
                    String propertyValue;
                    value = Base64.getDecoder().decode(propertyValue);
                    break;
                }
            }
        }
        if (encryptionType == null) {
            byArray = data;
            object = Charsets.UTF_8;
            boolean bl = false;
            boolean bl2 = false;
            CredentialStoreKt.getLOG().error("encryption type not specified in " + this.passwordFile + ", default one will be used (file content:\n" + new String(byArray, (Charset)object) + ')');
            encryptionType = EncryptionSupportKt.getDefaultEncryptionType();
        }
        if (value == null) {
            byArray = data;
            object = Charsets.UTF_8;
            boolean bl = false;
            boolean bl3 = false;
            CredentialStoreKt.getLOG().error("password not specified in " + this.passwordFile + ", automatically generated will be used (file content:\n" + new String(byArray, (Charset)object) + ')');
            return null;
        }
        return EncryptionSupportKt.createEncryptionSupport(new EncryptionSpec(encryptionType, null)).decrypt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@Nullable MasterKey key) {
        Closeable it2;
        if (key == null) {
            PathKt.delete$default((Path)this.passwordFile, (boolean)false, (int)1, null);
            return;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        EncryptionSupport encryptionSupport = EncryptionSupportKt.createEncryptionSupport(key.getEncryptionSpec());
        byte[] byArray = key.getValue();
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        byte[] encodedValue = encoder.encode(encryptionSupport.encrypt(byArray));
        key.clear();
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        EncryptionType encryptionType = key.getEncryptionSpec().getType();
        Closeable closeable = (OutputStream)out;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            it2 = (OutputStreamWriter)closeable;
            boolean bl3 = false;
            ((OutputStreamWriter)it2).append("encryption: ").append(encryptionType.name()).append('\n');
            ((OutputStreamWriter)it2).append("isAutoGenerated: ").append(String.valueOf(key.isAutoGenerated())).append('\n');
            it2 = ((OutputStreamWriter)it2).append("value: !!binary ");
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = PathKt.safeOutputStream((Path)this.passwordFile);
        bl2 = false;
        boolean bl4 = false;
        Throwable throwable2 = null;
        try {
            it2 = closeable;
            boolean bl5 = false;
            ((OutputStream)it2).write(out.getInternalBuffer(), 0, out.size());
            ((OutputStream)it2).write(encodedValue);
            ArraysKt.fill$default((byte[])encodedValue, (byte)0, (int)0, (int)0, (int)6, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
        }
    }

    private final boolean readMasterKeyIsAutoGeneratedMetadata(byte[] data) {
        boolean isAutoGenerated = true;
        for (NodeTuple node : MasterKeyKt.access$createMasterKeyReader(data)) {
            String string;
            Node keyNode = node.getKeyNode();
            Node valueNode = node.getValueNode();
            if (!(keyNode instanceof ScalarNode) || !(valueNode instanceof ScalarNode)) continue;
            if (((ScalarNode)valueNode).getValue() == null) {
                continue;
            }
            if (((ScalarNode)keyNode).getValue() == null) continue;
            switch (string.hashCode()) {
                case 1360734102: {
                    String propertyValue;
                    if (!string.equals("isAutoGenerated")) break;
                    String string2 = propertyValue;
                    boolean bl = false;
                    String string3 = string2;
                    boolean bl2 = false;
                    isAutoGenerated = Boolean.parseBoolean(string3) || Intrinsics.areEqual((Object)propertyValue, (Object)"yes");
                    break;
                }
            }
        }
        return isAutoGenerated;
    }

    public final boolean isAutoGenerated() {
        try {
            return this.readMasterKeyIsAutoGeneratedMetadata(PathKt.readBytes((Path)this.passwordFile));
        }
        catch (NoSuchFileException e) {
            return true;
        }
    }

    @NotNull
    public final Path getPasswordFile() {
        return this.passwordFile;
    }

    public MasterKeyFileStorage(@NotNull Path passwordFile) {
        this.passwordFile = passwordFile;
    }
}

