/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012\u001a\u0014\u0010\u001a\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u0016\u0010\u001d\u001a\u00020\u0010*\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"ACCESS_TO_KEY_CHAIN_DENIED", "Lcom/intellij/credentialStore/Credentials;", "getACCESS_TO_KEY_CHAIN_DENIED", "()Lcom/intellij/credentialStore/Credentials;", "CANNOT_UNLOCK_KEYCHAIN", "getCANNOT_UNLOCK_KEYCHAIN", "ESCAPING_CHAR", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createSecureRandom", "Ljava/security/SecureRandom;", "joinData", "", "user", "", "password", "Lcom/intellij/credentialStore/OneTimeString;", "parseString", "", "data", "delimiter", "splitData", "generateBytes", "size", "", "serialize", "storePassword", "", "intellij.platform.credentialStore"})
public final class CredentialStoreKt {
    @NotNull
    private static final Logger LOG;
    private static final char ESCAPING_CHAR = '\\';
    @NotNull
    private static final Credentials ACCESS_TO_KEY_CHAIN_DENIED;
    @NotNull
    private static final Credentials CANNOT_UNLOCK_KEYCHAIN;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final byte[] joinData(@Nullable String user, @Nullable OneTimeString password) {
        if (user == null && password == null) {
            return null;
        }
        String string = user;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder builder = new StringBuilder(string2);
        StringUtil.escapeChar((StringBuilder)builder, (char)'\\');
        StringUtil.escapeChar((StringBuilder)builder, (char)'@');
        if (password != null) {
            builder.append('@');
            password.appendTo(builder);
        }
        ByteBuffer buffer = Charsets.UTF_8.encode(CharBuffer.wrap(builder));
        builder.setLength(0);
        return IoKt.toByteArray$default((ByteBuffer)buffer, (boolean)false, (int)1, null);
    }

    @Nullable
    public static final Credentials splitData(@Nullable String data) {
        CharSequence charSequence = data;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        List<String> list = CredentialStoreKt.parseString(data, '@');
        return new Credentials((String)CollectionsKt.getOrNull(list, (int)0), (String)CollectionsKt.getOrNull(list, (int)1));
    }

    private static final List<String> parseString(String data, char delimiter) {
        StringBuilder part = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>(2);
        int i = 0;
        Character c = null;
        do {
            if ((c = StringsKt.getOrNull((CharSequence)data, (int)i++)) != null && c.charValue() != delimiter) {
                char c2 = '\\';
                if (c.charValue() == c2) {
                    c = StringsKt.getOrNull((CharSequence)data, (int)i++);
                }
                if (c != null) {
                    part.append(c.charValue());
                    continue;
                }
            }
            result.add(part.toString());
            part.setLength(0);
            if (i >= data.length()) continue;
            String string = data;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            result.add(string3);
            break;
        } while (c != null);
        return result;
    }

    @JvmOverloads
    @NotNull
    public static final byte[] serialize(@NotNull Credentials $this$serialize, boolean storePassword) {
        byte[] byArray = CredentialStoreKt.joinData($this$serialize.getUserName(), storePassword ? $this$serialize.getPassword() : null);
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        return byArray;
    }

    public static /* synthetic */ byte[] serialize$default(Credentials credentials2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return CredentialStoreKt.serialize(credentials2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final byte[] serialize(@NotNull Credentials $this$serialize) {
        return CredentialStoreKt.serialize$default($this$serialize, false, 1, null);
    }

    @NotNull
    public static final Credentials getACCESS_TO_KEY_CHAIN_DENIED() {
        return ACCESS_TO_KEY_CHAIN_DENIED;
    }

    @NotNull
    public static final Credentials getCANNOT_UNLOCK_KEYCHAIN() {
        return CANNOT_UNLOCK_KEYCHAIN;
    }

    @NotNull
    public static final SecureRandom createSecureRandom() {
        return new SecureRandom();
    }

    @NotNull
    public static final synchronized byte[] generateBytes(@NotNull SecureRandom $this$generateBytes, int size) {
        byte[] result = new byte[size];
        $this$generateBytes.nextBytes(result);
        return result;
    }

    static {
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(CredentialStore.class);
        ACCESS_TO_KEY_CHAIN_DENIED = new Credentials(null, (OneTimeString)null);
        CANNOT_UNLOCK_KEYCHAIN = new Credentials(null, (OneTimeString)null);
    }
}

