/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.automotiveMessagingService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"messagingServiceJava", "", "packageName", "serviceName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MessagingServiceJavaKt {
    @NotNull
    public static final String messagingServiceJava(@NotNull String packageName, @NotNull String serviceName2, boolean useAndroidX) {
        return "\npackage " + packageName + ";\n\nimport android.app.PendingIntent;\nimport android.app.Service;\nimport android.content.Intent;\nimport android.os.Handler;\nimport android.os.IBinder;\nimport android.os.Message;\nimport android.os.Messenger;\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat.CarExtender", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat.CarExtender.UnreadConversation", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationManagerCompat", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.RemoteInput", useAndroidX) + ";\n\npublic class " + serviceName2 + " extends Service {\n    private static final String TAG = " + serviceName2 + ".class.getSimpleName();\n\n    public static final String READ_ACTION =\n            \"" + packageName + ".ACTION_MESSAGE_READ\";\n    public static final String REPLY_ACTION =\n            \"" + packageName + ".ACTION_MESSAGE_REPLY\";\n    public static final String CONVERSATION_ID = \"conversation_id\";\n    public static final String EXTRA_VOICE_REPLY = \"extra_voice_reply\";\n\n    private NotificationManagerCompat mNotificationManager;\n\n    private final Messenger mMessenger = new Messenger(new IncomingHandler());\n\n    /**\n     * Handler of incoming messages from clients.\n     */\n    class IncomingHandler extends Handler {\n        @Override\n        public void handleMessage(Message msg) {\n            sendNotification(1, \"This is a sample message\", \"John Doe\",\n                    System.currentTimeMillis());\n        }\n    }\n\n    @Override\n    public void onCreate() {\n        mNotificationManager = NotificationManagerCompat.from(getApplicationContext());\n    }\n\n    @Override\n    public IBinder onBind(Intent intent) {\n        return mMessenger.getBinder();\n    }\n\n    @Override\n    public int onStartCommand(Intent intent, int flags, int startId) {\n        return START_STICKY;\n    }\n\n    private Intent createIntent(int conversationId, String action) {\n        return new Intent()\n                .addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)\n                .setAction(action)\n                .putExtra(CONVERSATION_ID, conversationId);\n    }\n\n    private void sendNotification(int conversationId, String message,\n                                  String participant, long timestamp) {\n        // A pending Intent for reads\n        PendingIntent readPendingIntent = PendingIntent.getBroadcast(getApplicationContext(),\n                conversationId,\n                createIntent(conversationId, READ_ACTION),\n                PendingIntent.FLAG_UPDATE_CURRENT);\n\n        // Build a RemoteInput for receiving voice input in a Car Notification\n        RemoteInput remoteInput = new RemoteInput.Builder(EXTRA_VOICE_REPLY)\n                .setLabel(\"Reply by voice\")\n                .build();\n\n        // Building a Pending Intent for the reply action to trigger\n        PendingIntent replyIntent = PendingIntent.getBroadcast(getApplicationContext(),\n                conversationId,\n                createIntent(conversationId, REPLY_ACTION),\n                PendingIntent.FLAG_UPDATE_CURRENT);\n\n        // Create the UnreadConversation and populate it with the participant name,\n        // read and reply intents.\n        UnreadConversation.Builder unreadConvBuilder =\n                new UnreadConversation.Builder(participant)\n                .setLatestTimestamp(timestamp)\n                .setReadPendingIntent(readPendingIntent)\n                .setReplyAction(replyIntent, remoteInput);\n\n        NotificationCompat.Builder builder = new NotificationCompat.Builder(getApplicationContext())\n                // Set the application notification icon:\n                //.setSmallIcon(R.drawable.notification_icon)\n\n                // Set the large icon, for example a picture of the other recipient of the message\n                //.setLargeIcon(personBitmap)\n\n                .setContentText(message)\n                .setWhen(timestamp)\n                .setContentTitle(participant)\n                .setContentIntent(readPendingIntent)\n                .extend(new CarExtender()\n                        .setUnreadConversation(unreadConvBuilder.build()));\n\n        mNotificationManager.notify(conversationId, builder.build());\n    }\n}\n";
    }
}

