/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"videoDetailsFragmentKt", "", "activityClass", "detailsActivity", "detailsFragment", "minApiLevel", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class VideoDetailsFragmentKtKt {
    @NotNull
    public static final String videoDetailsFragmentKt(@NotNull String activityClass2, @NotNull String detailsActivity2, @NotNull String detailsFragment2, int minApiLevel, @NotNull String packageName, boolean useAndroidX) {
        String contextArgBlock = minApiLevel >= 23 ? "context!!" : "activity!!";
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.content.Context\nimport android.content.Intent\nimport android.graphics.Bitmap\nimport android.os.Bundle\nimport android.graphics.drawable.Drawable\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.app.DetailsSupportFragment", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.app.DetailsSupportFragmentBackgroundController", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Action", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ArrayObjectAdapter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ClassPresenterSelector", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.DetailsOverviewRow", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.FullWidthDetailsOverviewRowPresenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.FullWidthDetailsOverviewSharedElementHelper", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.HeaderItem", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ImageCardView", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ListRow", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ListRowPresenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.OnActionClickedListener", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.OnItemViewClickedListener", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Presenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Row", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.RowPresenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.ActivityOptionsCompat", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX) + "\nimport android.util.Log\nimport android.widget.Toast\n\nimport com.bumptech.glide.Glide\nimport com.bumptech.glide.request.target.SimpleTarget\nimport com.bumptech.glide.request.transition.Transition\n\nimport java.util.Collections\n\n/**\n * A wrapper fragment for leanback details screens.\n * It shows a detailed view of video and its metadata plus related videos.\n */\nclass " + detailsFragment2 + " : DetailsSupportFragment() {\n\n    private var mSelectedMovie: Movie? = null\n\n    private lateinit var mDetailsBackground: DetailsSupportFragmentBackgroundController\n    private lateinit var mPresenterSelector: ClassPresenterSelector\n    private lateinit var mAdapter: ArrayObjectAdapter\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        Log.d(TAG, \"onCreate DetailsFragment\")\n        super.onCreate(savedInstanceState)\n\n        mDetailsBackground = DetailsSupportFragmentBackgroundController(this)\n\n        mSelectedMovie = activity!!.intent.getSerializableExtra(" + detailsActivity2 + ".MOVIE) as Movie\n        if (mSelectedMovie != null) {\n            mPresenterSelector = ClassPresenterSelector()\n            mAdapter = ArrayObjectAdapter(mPresenterSelector)\n            setupDetailsOverviewRow()\n            setupDetailsOverviewRowPresenter()\n            setupRelatedMovieListRow()\n            adapter = mAdapter\n            initializeBackground(mSelectedMovie)\n            onItemViewClickedListener = ItemViewClickedListener()\n        } else {\n            val intent = Intent(" + contextArgBlock + ", " + activityClass2 + "::class.java)\n            startActivity(intent)\n        }\n    }\n\n    private fun initializeBackground(movie: Movie?) {\n        mDetailsBackground.enableParallax()\n        Glide.with(" + contextArgBlock + ")\n                .asBitmap()\n                .centerCrop()\n                .error(R.drawable.default_background)\n                .load(movie?.backgroundImageUrl)\n                .into<SimpleTarget<Bitmap>>(object : SimpleTarget<Bitmap>() {\n                    override fun onResourceReady(bitmap: Bitmap,\n                                                 transition: Transition<in Bitmap>?) {\n                        mDetailsBackground.coverBitmap = bitmap\n                        mAdapter.notifyArrayItemRangeChanged(0, mAdapter.size())\n                    }\n                })\n    }\n\n    private fun setupDetailsOverviewRow() {\n        Log.d(TAG, \"doInBackground: \" + mSelectedMovie?.toString())\n        val row = DetailsOverviewRow(mSelectedMovie)\n        row.imageDrawable = ContextCompat.getDrawable(" + contextArgBlock + ", R.drawable.default_background)\n        val width = convertDpToPixel(" + contextArgBlock + ", DETAIL_THUMB_WIDTH)\n        val height = convertDpToPixel(" + contextArgBlock + ", DETAIL_THUMB_HEIGHT)\n        Glide.with(" + contextArgBlock + ")\n            .load(mSelectedMovie?.cardImageUrl)\n            .centerCrop()\n            .error(R.drawable.default_background)\n            .into<SimpleTarget<Drawable>>(object : SimpleTarget<Drawable>(width, height) {\n                        override fun onResourceReady(drawable: Drawable,\n                                                     transition: Transition<in Drawable>?) {\n                            Log.d(TAG, \"details overview card image url ready: \" + drawable)\n                            row.imageDrawable = drawable\n                            mAdapter.notifyArrayItemRangeChanged(0, mAdapter.size())\n                        }\n                    })\n\n        val actionAdapter = ArrayObjectAdapter()\n\n        actionAdapter.add(\n                Action(\n                        ACTION_WATCH_TRAILER,\n                        resources.getString(R.string.watch_trailer_1),\n                        resources.getString(R.string.watch_trailer_2)))\n        actionAdapter.add(\n                Action(\n                        ACTION_RENT,\n                        resources.getString(R.string.rent_1),\n                        resources.getString(R.string.rent_2)))\n        actionAdapter.add(\n                Action(\n                        ACTION_BUY,\n                        resources.getString(R.string.buy_1),\n                        resources.getString(R.string.buy_2)))\n        row.actionsAdapter = actionAdapter\n\n        mAdapter.add(row)\n    }\n\n    private fun setupDetailsOverviewRowPresenter() {\n        // Set detail background.\n        val detailsPresenter = FullWidthDetailsOverviewRowPresenter(DetailsDescriptionPresenter())\n        detailsPresenter.backgroundColor =\n                ContextCompat.getColor(" + contextArgBlock + ", R.color.selected_background)\n\n        // Hook up transition element.\n        val sharedElementHelper = FullWidthDetailsOverviewSharedElementHelper()\n        sharedElementHelper.setSharedElementEnterTransition(\n                activity, " + detailsActivity2 + ".SHARED_ELEMENT_NAME)\n        detailsPresenter.setListener(sharedElementHelper)\n        detailsPresenter.isParticipatingEntranceTransition = true\n\n        detailsPresenter.onActionClickedListener = OnActionClickedListener { action ->\n            if (action.id == ACTION_WATCH_TRAILER) {\n                val intent = Intent(" + contextArgBlock + ", PlaybackActivity::class.java)\n                intent.putExtra(" + detailsActivity2 + ".MOVIE, mSelectedMovie)\n                startActivity(intent)\n            } else {\n                Toast.makeText(" + contextArgBlock + ", action.toString(), Toast.LENGTH_SHORT).show()\n            }\n        }\n        mPresenterSelector.addClassPresenter(DetailsOverviewRow::class.java, detailsPresenter)\n    }\n\n    private fun setupRelatedMovieListRow() {\n        val subcategories = arrayOf(getString(R.string.related_movies))\n        val list = MovieList.list\n\n        Collections.shuffle(list)\n        val listRowAdapter = ArrayObjectAdapter(CardPresenter())\n        for (j in 0 until NUM_COLS ) {\n            listRowAdapter.add(list[j % 5])\n        }\n\n        val header = HeaderItem(0, subcategories[0])\n        mAdapter.add(ListRow(header, listRowAdapter))\n        mPresenterSelector.addClassPresenter(ListRow::class.java, ListRowPresenter())\n    }\n\n    private fun convertDpToPixel(context: Context, dp: Int): Int {\n        val density = context.applicationContext.resources.displayMetrics.density\n        return Math.round(dp.toFloat() * density)\n    }\n\n    private inner class ItemViewClickedListener : OnItemViewClickedListener {\n        override fun onItemClicked(\n                itemViewHolder: Presenter.ViewHolder?,\n                item: Any?,\n                rowViewHolder: RowPresenter.ViewHolder,\n                row: Row) {\n            if (item is Movie) {\n                Log.d(TAG, \"Item: \" + item.toString())\n                val intent = Intent(" + contextArgBlock + ", " + detailsActivity2 + "::class.java)\n                intent.putExtra(resources.getString(R.string.movie), mSelectedMovie)\n\n                val bundle =\n                        ActivityOptionsCompat.makeSceneTransitionAnimation(\n                            activity!!,\n                            (itemViewHolder?.view as ImageCardView).mainImageView,\n                            " + detailsActivity2 + ".SHARED_ELEMENT_NAME)\n                        .toBundle()\n                startActivity(intent, bundle)\n            }\n        }\n    }\n\n    companion object {\n        private val TAG = \"" + StringsKt.take((String)detailsFragment2, (int)23) + "\"\n\n        private val ACTION_WATCH_TRAILER = 1L\n        private val ACTION_RENT = 2L\n        private val ACTION_BUY = 3L\n\n        private val DETAIL_THUMB_WIDTH = 274\n        private val DETAIL_THUMB_HEIGHT = 274\n\n        private val NUM_COLS = 10\n    }\n}\n";
    }
}

