/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;

public final class OneToManyPathsMapping
extends AbstractStateStorage<String, Collection<String>> {
    private final PathRelativizerService myRelativizer;

    public OneToManyPathsMapping(File storePath, PathRelativizerService relativizer) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new PathCollectionExternalizer());
        this.myRelativizer = relativizer;
    }

    @Override
    public void update(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        super.update(this.normalizePath(keyPath), this.normalizePaths(boundPaths));
    }

    @Override
    public final void update(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        super.update(this.normalizePath(keyPath), Collections.singleton(this.normalizePath(boundPath)));
    }

    @Override
    public final void appendData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        super.appendData(this.normalizePath(keyPath), Collections.singleton(this.normalizePath(boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        super.appendData(this.normalizePath(keyPath), this.normalizePaths(boundPaths));
    }

    @Override
    @Nullable
    public Collection<String> getState(@NotNull String keyPath) throws IOException {
        Collection collection = (Collection)super.getState(this.normalizePath(keyPath));
        return collection != null ? ContainerUtil.map((Collection)collection, this.toFull()) : null;
    }

    @Override
    public void remove(@NotNull String keyPath) throws IOException {
        super.remove(this.normalizePath(keyPath));
    }

    @Override
    public Collection<String> getKeys() throws IOException {
        Collection keys = super.getKeys();
        return keys != null ? ContainerUtil.map(keys, this.toFull()) : null;
    }

    @Override
    public Iterator<String> getKeysIterator() throws IOException {
        return JBIterator.from(super.getKeysIterator()).map(this.toFull());
    }

    public final void removeData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        Collection<String> outputPaths = this.getState(keyPath);
        if (outputPaths != null) {
            boolean removed = outputPaths.remove(this.normalizePath(boundPath));
            if (outputPaths.isEmpty()) {
                this.remove(keyPath);
            } else if (removed) {
                this.update(keyPath, outputPaths);
            }
        }
    }

    @NotNull
    private Function<String, String> toFull() {
        return s -> this.myRelativizer.toFull((String)s);
    }

    private String normalizePath(@NotNull String path) {
        return this.myRelativizer.toRelative(path);
    }

    private Collection<String> normalizePaths(Collection<String> outputs) {
        ArrayList<String> normalized = new ArrayList<String>(outputs.size());
        for (String out : outputs) {
            normalized.add(this.normalizePath(out));
        }
        return normalized;
    }

    private static class PathCollectionExternalizer
    implements DataExternalizer<Collection<String>> {
        private PathCollectionExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            for (String str : value) {
                IOUtil.writeUTF((DataOutput)out, (String)str);
            }
        }

        public Collection<String> read(@NotNull DataInput in) throws IOException {
            Set result = CollectionFactory.createFilePathLinkedSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String str = IOUtil.readUTF((DataInput)stream);
                result.add(str);
            }
            return result;
        }
    }
}

