/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreatorBase;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.PackIntoArchiveInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.SkipAllInstructionCreator;

public class CopyToDirectoryInstructionCreator
extends ArtifactCompilerInstructionCreatorBase {
    private final String myOutputPath;

    public CopyToDirectoryInstructionCreator(ArtifactInstructionsBuilderImpl builder, String outputPath) {
        super(builder);
        this.myOutputPath = outputPath;
    }

    @Override
    protected DestinationInfo createFileDestination(@NotNull String outputFileName) {
        return new ExplodedDestinationInfo(this.myOutputPath + "/" + outputFileName);
    }

    @Override
    protected ExplodedDestinationInfo createDirectoryDestination() {
        return new ExplodedDestinationInfo(this.myOutputPath);
    }

    @Override
    protected void onAdded(ArtifactRootDescriptor descriptor) {
    }

    @Override
    public CopyToDirectoryInstructionCreator subFolder(@NotNull String directoryName) {
        return new CopyToDirectoryInstructionCreator(this.myInstructionsBuilder, this.myOutputPath + "/" + directoryName);
    }

    @Override
    public ArtifactCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        String jarOutputPath = this.myOutputPath + "/" + archiveFileName;
        ExplodedDestinationInfo destination = new ExplodedDestinationInfo(jarOutputPath);
        JarInfo jarInfo = new JarInfo(destination);
        if (!this.myInstructionsBuilder.registerJarFile(jarInfo, jarOutputPath)) {
            return new SkipAllInstructionCreator(this.myInstructionsBuilder);
        }
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, jarInfo, "", destination);
    }

    @Override
    @Nullable
    public File getTargetDirectory() {
        return new File(this.myOutputPath);
    }
}

