/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.module.JpsModule;

public class CompileScopeImpl
extends CompileScope {
    private final Collection<? extends BuildTargetType<?>> myTypes;
    private final Collection<BuildTargetType<?>> myTypesToForceBuild;
    private final Collection<BuildTarget<?>> myTargets;
    private final Map<BuildTarget<?>, Set<File>> myFiles;
    private final Map<BuildTarget<?>, Set<File>> myIndirectlyAffectedFiles = Collections.synchronizedMap(new HashMap());

    public CompileScopeImpl(Collection<? extends BuildTargetType<?>> types, Collection<? extends BuildTargetType<?>> typesToForceBuild, Collection<BuildTarget<?>> targets, @NotNull Map<BuildTarget<?>, Set<File>> files) {
        this.myTypes = types;
        this.myTypesToForceBuild = new HashSet();
        boolean forceBuildAllModuleBasedTargets = false;
        for (BuildTargetType<?> type : typesToForceBuild) {
            this.myTypesToForceBuild.add(type);
            forceBuildAllModuleBasedTargets |= type instanceof JavaModuleBuildTargetType;
        }
        if (forceBuildAllModuleBasedTargets) {
            for (BuildTargetType<?> targetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
                if (!(targetType instanceof ModuleBasedBuildTargetType)) continue;
                this.myTypesToForceBuild.add(targetType);
            }
        }
        this.myTargets = targets;
        this.myFiles = files;
    }

    @Override
    public boolean isAffected(@NotNull BuildTarget<?> target) {
        return this.isWholeTargetAffected(target) || this.myFiles.containsKey(target) || this.myIndirectlyAffectedFiles.containsKey(target);
    }

    @Override
    public boolean isWholeTargetAffected(@NotNull BuildTarget<?> target) {
        return (this.myTypes.contains(target.getTargetType()) || this.myTargets.contains(target) || this.isAffectedByAssociatedModule(target)) && !this.myFiles.containsKey(target);
    }

    @Override
    public boolean isAllTargetsOfTypeAffected(@NotNull BuildTargetType<?> type) {
        return this.myTypes.contains(type) && this.myFiles.isEmpty();
    }

    @Override
    public boolean isBuildForced(@NotNull BuildTarget<?> target) {
        return this.myFiles.isEmpty() && this.myTypesToForceBuild.contains(target.getTargetType()) && this.isWholeTargetAffected(target);
    }

    @Override
    public boolean isBuildForcedForAllTargets(@NotNull BuildTargetType<?> targetType) {
        return this.myTypesToForceBuild.contains(targetType) && this.isAllTargetsOfTypeAffected(targetType);
    }

    @Override
    public boolean isBuildIncrementally(@NotNull BuildTargetType<?> targetType) {
        return !this.myTypesToForceBuild.contains(targetType);
    }

    @Override
    public boolean isAffected(BuildTarget<?> target, @NotNull File file) {
        Set<File> files;
        Set<File> set = files = this.myFiles.isEmpty() ? null : this.myFiles.get(target);
        if (files == null) {
            return this.isWholeTargetAffected(target) || this.isIndirectlyAffected(target, file);
        }
        return files.contains(file) || this.isIndirectlyAffected(target, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIndirectlyAffected(BuildTarget<?> target, @NotNull File file) {
        Map<BuildTarget<?>, Set<File>> map = this.myIndirectlyAffectedFiles;
        synchronized (map) {
            Set<File> indirect = this.myIndirectlyAffectedFiles.get(target);
            return indirect != null && indirect.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIndirectlyAffected(BuildTarget<?> target, @NotNull File file) {
        Map<BuildTarget<?>, Set<File>> map = this.myIndirectlyAffectedFiles;
        synchronized (map) {
            Set<File> files = this.myIndirectlyAffectedFiles.get(target);
            if (files == null) {
                files = new HashSet<File>();
                this.myIndirectlyAffectedFiles.put(target, files);
            }
            files.add(file);
        }
    }

    private boolean isAffectedByAssociatedModule(BuildTarget<?> target) {
        if (target instanceof ModuleBasedTarget) {
            JpsModule module = ((ModuleBasedTarget)target).getModule();
            JavaModuleBuildTargetType targetType = JavaModuleBuildTargetType.getInstance(((ModuleBasedTarget)target).isTests());
            if (this.myTypes.contains(targetType) || this.myTargets.contains(new ModuleBuildTarget(module, targetType))) {
                return true;
            }
        }
        return false;
    }
}

