/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;

class ClassFileReprExternalizer
implements DataExternalizer<ClassFileRepr> {
    private static final byte CLASS = 1;
    private static final byte MODULE = 2;
    private final DataExternalizer<ClassRepr> myClassReprExternalizer;
    private final DataExternalizer<ModuleRepr> myModuleReprExternalizer;

    ClassFileReprExternalizer(DependencyContext context) {
        this.myClassReprExternalizer = ClassRepr.externalizer(context);
        this.myModuleReprExternalizer = ModuleRepr.externalizer(context);
    }

    public void save(@NotNull DataOutput out, ClassFileRepr value) throws IOException {
        if (value instanceof ClassRepr) {
            out.writeByte(1);
            this.myClassReprExternalizer.save(out, (Object)((ClassRepr)value));
        } else {
            out.writeByte(2);
            this.myModuleReprExternalizer.save(out, (Object)((ModuleRepr)value));
        }
    }

    public ClassFileRepr read(@NotNull DataInput in) throws IOException {
        return in.readByte() == 1 ? (ClassFileRepr)this.myClassReprExternalizer.read(in) : (ClassFileRepr)this.myModuleReprExternalizer.read(in);
    }
}

