/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;

public abstract class BuildTarget<R extends BuildRootDescriptor> {
    private final BuildTargetType<? extends BuildTarget<R>> myTargetType;

    protected BuildTarget(BuildTargetType<? extends BuildTarget<R>> targetType) {
        this.myTargetType = targetType;
    }

    public abstract String getId();

    public final BuildTargetType<? extends BuildTarget<R>> getTargetType() {
        return this.myTargetType;
    }

    public abstract Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry var1, TargetOutputIndex var2);

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
    }

    @NotNull
    public abstract List<R> computeRootDescriptors(JpsModel var1, ModuleExcludeIndex var2, IgnoredFileIndex var3, BuildDataPaths var4);

    @Nullable
    public abstract R findRootDescriptor(String var1, BuildRootIndex var2);

    @NotNull
    public abstract String getPresentableName();

    @NotNull
    public abstract Collection<File> getOutputRoots(CompileContext var1);

    public String toString() {
        return this.getPresentableName();
    }
}

