/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;

public class ObjectCollector<T, E extends Exception> {
    private final TObjectIntHashMap<T> myObjectMap;
    private int instanceCounter = 0;

    public ObjectCollector() {
        this(TObjectHashingStrategy.CANONICAL);
    }

    public ObjectCollector(TObjectHashingStrategy<T> hashingStrategy) {
        this.myObjectMap = new TObjectIntHashMap(hashingStrategy);
    }

    public void add(@NotNull T object, @NotNull Processor<? extends E> consumer) throws E {
        boolean isNew;
        int objectId = this.myObjectMap.get(object);
        boolean bl = isNew = objectId == 0;
        if (isNew) {
            int newId = ++this.instanceCounter;
            this.myObjectMap.put(object, newId);
            objectId = newId;
        }
        consumer.process(isNew, objectId);
    }

    public static interface Processor<E extends Exception> {
        public void process(boolean var1, int var2) throws E;
    }
}

