/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public class GradleVersionComparator
implements Comparable<GradleVersion> {
    private final GradleVersion myVersion;
    private final TObjectIntHashMap<String> myResults = new TObjectIntHashMap();
    private final THashMap<String, GradleVersion> myVersionsMap = new THashMap();

    public GradleVersionComparator(@NotNull GradleVersion gradleVersion) {
        this.myVersion = gradleVersion;
    }

    @Override
    public int compareTo(@NotNull GradleVersion gradleVersion) {
        if (this.myVersion == gradleVersion) {
            return 0;
        }
        String version = gradleVersion.getVersion();
        if (this.myVersion.getVersion().equals(version)) {
            return 0;
        }
        int result = this.myResults.get((Object)version);
        if (result != 0) {
            return result;
        }
        result = this.myVersion.compareTo(gradleVersion);
        this.myResults.put((Object)version, result);
        return result;
    }

    public boolean lessThan(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) < 0;
    }

    public boolean lessThan(@NotNull String gradleVersion) {
        return this.lessThan(this.getGradleVersion(gradleVersion));
    }

    public boolean isOrGreaterThan(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) >= 0;
    }

    public boolean isOrGreaterThan(@NotNull String gradleVersion) {
        return this.isOrGreaterThan(this.getGradleVersion(gradleVersion));
    }

    public boolean is(@NotNull GradleVersion gradleVersion) {
        return this.compareTo(gradleVersion) == 0;
    }

    public boolean is(@NotNull String gradleVersion) {
        return this.is(this.getGradleVersion(gradleVersion));
    }

    @NotNull
    private GradleVersion getGradleVersion(@NotNull String gradleVersion) {
        GradleVersion version = (GradleVersion)this.myVersionsMap.get((Object)gradleVersion);
        if (version == null) {
            version = GradleVersion.version((String)gradleVersion);
            this.myVersionsMap.put((Object)gradleVersion, (Object)version);
        }
        return version;
    }
}

