/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import java.io.IOException;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.DefaultSerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.util.ClassMap;

public class ToolingSerializer {
    private final DefaultSerializationService myDefaultSerializationService = new DefaultSerializationService();
    private final ClassMap<SerializationService<?>> mySerializationServices = new ClassMap();

    public ToolingSerializer() {
        for (SerializationService serializerService : ServiceLoader.load(SerializationService.class, SerializationService.class.getClassLoader())) {
            this.register(serializerService);
        }
    }

    public final void register(@NotNull SerializationService<?> serializerService) {
        this.mySerializationServices.put(serializerService.getModelClass(), serializerService);
    }

    public byte[] write(@NotNull Object object, @NotNull Class modelClazz) throws IOException {
        return this.getService(modelClazz).write(object, modelClazz);
    }

    @Nullable
    public <T> T read(@NotNull byte[] object, @NotNull Class<T> modelClazz) throws IOException {
        return this.getService(modelClazz).read(object, modelClazz);
    }

    @NotNull
    private <T> SerializationService<T> getService(@NotNull Class<T> modelClazz) {
        DefaultSerializationService service = this.mySerializationServices.get(modelClazz);
        return service == null ? this.myDefaultSerializationService : service;
    }
}

