/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingSerializer;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.IdeaProjectSerializationService;

public abstract class ModelsHolder<B extends BuildModel, P extends ProjectModel>
implements Serializable {
    @NotNull
    private final B myRootModel;
    @NotNull
    private final Map<String, Object> myModelsById = new LinkedHashMap<String, Object>();
    @Nullable
    private ToolingSerializer mySerializer;

    public ModelsHolder(@NotNull B rootModel) {
        this.myRootModel = rootModel;
    }

    public void initToolingSerializer(@NotNull GradleVersion gradleVersion) {
        this.mySerializer = new ToolingSerializer();
        this.mySerializer.register(new IdeaProjectSerializationService(gradleVersion));
    }

    @NotNull
    protected B getRootModel() {
        return this.myRootModel;
    }

    @Nullable
    public <T> T getModel(@NotNull Class<T> modelClazz) {
        return this.getModel((P)this.getRootModel(), modelClazz);
    }

    @Nullable
    public <T> T getModel(@NotNull B build, @NotNull Class<T> modelClazz) {
        String key = ModelsHolder.extractMapKey(modelClazz, build.getBuildIdentifier());
        return this.getModel(modelClazz, key);
    }

    @Nullable
    public <T> T getModel(@NotNull P project, @NotNull Class<T> modelClazz) {
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        String key = ModelsHolder.extractMapKey(modelClazz, projectIdentifier);
        return this.getModel(modelClazz, key);
    }

    @Nullable
    private <T> T getModel(@NotNull Class<T> modelClazz, @NotNull String key) {
        Object model = this.myModelsById.get(key);
        if (model == null) {
            return null;
        }
        if (modelClazz.isInstance(model)) {
            return (T)model;
        }
        this.deserializeAllDataOfTheType(modelClazz);
        return (T)this.myModelsById.get(key);
    }

    private <T> void deserializeAllDataOfTheType(@NotNull Class<T> modelClazz) {
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        Iterator<Map.Entry<String, Object>> iterator = this.myModelsById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            if (!key.startsWith(keyPrefix)) continue;
            if (this.mySerializer == null || !(entry.getValue() instanceof byte[])) {
                iterator.remove();
                continue;
            }
            try {
                T deserializedData = this.mySerializer.read((byte[])entry.getValue(), modelClazz);
                if (modelClazz.isInstance(deserializedData)) {
                    this.myModelsById.put(key, deserializedData);
                    continue;
                }
                iterator.remove();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                iterator.remove();
            }
        }
    }

    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        for (String key : this.myModelsById.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz) {
        this.addModel(model, modelClazz, this.getRootModel());
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull P project) {
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        this.myModelsById.put(ModelsHolder.extractMapKey(modelClazz, projectIdentifier), model);
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull B build) {
        this.myModelsById.put(ModelsHolder.extractMapKey(modelClazz, build.getBuildIdentifier()), model);
    }

    @NotNull
    private static String getModelKeyPrefix(@NotNull Class modelClazz) {
        return modelClazz.getSimpleName() + modelClazz.getName().hashCode();
    }

    @NotNull
    private static String extractMapKey(@NotNull Class modelClazz, @NotNull ProjectIdentifier projectIdentifier) {
        String prefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        BuildIdentifier buildIdentifier = projectIdentifier.getBuildIdentifier();
        return prefix + '/' + buildIdentifier.getRootDir().getPath().hashCode() + projectIdentifier.getProjectPath();
    }

    @NotNull
    private static String extractMapKey(@NotNull Class modelClazz, @NotNull BuildIdentifier buildIdentifier) {
        String prefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        return prefix + '/' + buildIdentifier.getRootDir().getPath().hashCode() + ":";
    }

    private ProjectIdentifier getProjectIdentifier(@NotNull P project) {
        ProjectIdentifier projectIdentifier = project instanceof IdeaModule ? ((IdeaModule)project).getGradleProject().getProjectIdentifier() : project.getProjectIdentifier();
        return projectIdentifier;
    }

    public String toString() {
        return "Models{rootModel=" + this.myRootModel + ", myModelsById=" + this.myModelsById + '}';
    }

    boolean hasModels() {
        return !this.myModelsById.isEmpty();
    }
}

