/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.MergeRange;
import org.jetbrains.idea.svn.mergeinfo.MergeRangeList;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class BranchInfo {
    private static final Logger LOG = Logger.getInstance(BranchInfo.class);
    @NotNull
    private final Map<String, Set<Long>> myPathMergedMap;
    @NotNull
    private final Map<String, Set<Long>> myNonInheritablePathMergedMap;
    private boolean myMixedRevisionsFound;
    @NotNull
    private final Map<Long, MergeCheckResult> myAlreadyCalculatedMap;
    @NotNull
    private final Object myCalculatedLock = new Object();
    @NotNull
    private final WCInfoWithBranches myInfo;
    @NotNull
    private final WCInfoWithBranches.Branch myBranch;
    @NotNull
    private final SvnVcs myVcs;
    private SvnMergeInfoCache.CopyRevison myCopyRevison;
    @NotNull
    private final MultiMap<Long, String> myPartlyMerged;

    public BranchInfo(@NotNull SvnVcs vcs, @NotNull WCInfoWithBranches info2, @NotNull WCInfoWithBranches.Branch branch) {
        this.myVcs = vcs;
        this.myInfo = info2;
        this.myBranch = branch;
        this.myPathMergedMap = new HashMap<String, Set<Long>>();
        this.myPartlyMerged = MultiMap.create();
        this.myNonInheritablePathMergedMap = new HashMap<String, Set<Long>>();
        this.myAlreadyCalculatedMap = new HashMap<Long, MergeCheckResult>();
    }

    private long calculateCopyRevision(String branchPath) {
        if (this.myCopyRevison != null && Objects.equals(this.myCopyRevison.getPath(), branchPath)) {
            return this.myCopyRevison.getRevision();
        }
        this.myCopyRevison = new SvnMergeInfoCache.CopyRevison(this.myVcs, branchPath, this.myInfo.getRootInfo().getRepositoryUrl(), this.myBranch.getUrl(), this.myInfo.getUrl());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.clear();
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MergeInfoCached getCached() {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.myCopyRevison != null ? this.myCopyRevison.getRevision() : -1L;
            return new MergeInfoCached(Collections.unmodifiableMap(this.myAlreadyCalculatedMap), revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MergeCheckResult checkList(@NotNull SvnChangeList list, String branchPath) {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.calculateCopyRevision(branchPath);
            MergeCheckResult result = revision != -1L && revision >= list.getNumber() ? MergeCheckResult.COMMON : (MergeCheckResult)((Object)ContainerUtil.getOrCreate(this.myAlreadyCalculatedMap, (Object)list.getNumber(), () -> this.checkAlive(list, branchPath)));
            return result;
        }
    }

    @NotNull
    private MergeCheckResult checkAlive(@NotNull SvnChangeList list, @NotNull String branchPath) {
        Info info2 = this.myVcs.getInfo(new File(branchPath));
        if (info2 == null || info2.getUrl() == null || !SvnUtil.isAncestor(this.myBranch.getUrl(), info2.getUrl())) {
            return MergeCheckResult.NOT_MERGED;
        }
        MultiMap<MergeCheckResult, String> result = this.checkPaths(list, branchPath, info2.getUrl());
        if (result.containsKey((Object)MergeCheckResult.NOT_EXISTS)) {
            return MergeCheckResult.NOT_EXISTS;
        }
        if (result.containsKey((Object)MergeCheckResult.NOT_MERGED)) {
            this.myPartlyMerged.put((Object)list.getNumber(), result.get((Object)MergeCheckResult.NOT_MERGED));
            return MergeCheckResult.NOT_MERGED;
        }
        return MergeCheckResult.MERGED;
    }

    @NotNull
    private MultiMap<MergeCheckResult, String> checkPaths(@NotNull SvnChangeList list, @NotNull String branchPath, @NotNull Url underBranchUrl) {
        MultiMap result = MultiMap.create();
        String subPathUnderBranch = SvnUtil.getRelativeUrl(this.myBranch.getUrl(), underBranchUrl);
        Url myTrunkUrlCorrespondingToLocalBranchPath = BranchInfo.appendPath(this.myInfo.getCurrentBranch().getUrl(), subPathUnderBranch);
        for (String path : list.getAffectedPaths()) {
            MergeCheckResult mergeCheckResult;
            Url url = BranchInfo.appendPath(this.myInfo.getRepoUrl(), path);
            if (!SvnUtil.isAncestor(myTrunkUrlCorrespondingToLocalBranchPath, url)) {
                mergeCheckResult = MergeCheckResult.NOT_EXISTS;
            } else {
                String relativeToTrunkPath = SvnUtil.getRelativeUrl(myTrunkUrlCorrespondingToLocalBranchPath, url);
                String localPathInBranch = new File(branchPath, relativeToTrunkPath).getAbsolutePath();
                try {
                    mergeCheckResult = this.checkPathGoingUp(list.getNumber(), -1L, branchPath, localPathInBranch, path, true);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = MergeCheckResult.NOT_MERGED;
                }
            }
            result.putValue((Object)mergeCheckResult, (Object)path);
            if (!MergeCheckResult.NOT_EXISTS.equals((Object)mergeCheckResult)) continue;
            break;
        }
        return result;
    }

    @NotNull
    private MergeCheckResult goUp(long revisionAsked, long targetRevision, String branchRootPath, String path, @NotNull String trunkUrl) throws VcsException {
        Info svnInfo;
        String newPath;
        String newTrunkUrl = Url.removeTail(trunkUrl).trim();
        MergeCheckResult result = newTrunkUrl.length() == 0 || "/".equals(newTrunkUrl) ? MergeCheckResult.NOT_MERGED : ((newPath = new File(path).getParent()).length() < branchRootPath.length() ? (targetRevision == -1L ? MergeCheckResult.NOT_EXISTS : ((svnInfo = this.myVcs.getInfo(new File(branchRootPath))) == null || svnInfo.getUrl() == null ? MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, SvnUtil.removePathTail(svnInfo.getUrl()), newTrunkUrl))) : this.checkPathGoingUp(revisionAsked, targetRevision, branchRootPath, newPath, newTrunkUrl, false));
        return result;
    }

    @NotNull
    private MergeCheckResult goUpInRepo(long revisionAsked, long targetRevision, Url branchUrl, String trunkUrl) throws VcsException {
        MergeCheckResult result;
        Set<Long> mergeInfo = this.myPathMergedMap.get(branchUrl.toString() + "@" + targetRevision);
        if (mergeInfo != null) {
            result = MergeCheckResult.getInstance(mergeInfo.contains(revisionAsked));
        } else {
            Target target = Target.on(branchUrl);
            PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, Revision.of(targetRevision));
            if (mergeinfoProperty == null) {
                String newTrunkUrl = Url.removeTail(trunkUrl).trim();
                Url newBranchUrl = SvnUtil.removePathTail(branchUrl);
                Url absoluteTrunk = SvnUtil.append(this.myInfo.getRepoUrl(), newTrunkUrl);
                result = newTrunkUrl.length() <= 1 || newBranchUrl.toString().length() <= this.myInfo.getRepoUrl().toString().length() || newBranchUrl.equals(absoluteTrunk) ? MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, newBranchUrl, newTrunkUrl);
            } else {
                result = this.processMergeinfoProperty(branchUrl.toString() + "@" + targetRevision, revisionAsked, mergeinfoProperty, trunkUrl, false);
            }
        }
        return result;
    }

    @NotNull
    private MergeCheckResult checkPathGoingUp(long revisionAsked, long targetRevision, @NotNull String branchRootPath, @NotNull String path, String trunkUrl, boolean self) throws VcsException {
        MergeCheckResult result;
        File pathFile = new File(path);
        if (targetRevision == -1L && !pathFile.exists()) {
            result = this.goUp(revisionAsked, targetRevision, branchRootPath, path, trunkUrl);
        } else {
            Info svnInfo = this.myVcs.getInfo(pathFile);
            if (svnInfo == null || svnInfo.getUrl() == null) {
                LOG.info("Svninfo for " + pathFile + " is null or not full.");
                result = MergeCheckResult.NOT_MERGED;
            } else {
                long actualRevision = svnInfo.getRevision().getNumber();
                long targetRevisionCorrected = targetRevision == -1L ? actualRevision : targetRevision;
                String keyString = path + "@" + targetRevisionCorrected;
                Set<Long> selfInfo = self ? this.myNonInheritablePathMergedMap.get(keyString) : null;
                Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
                if (mergeInfo != null || selfInfo != null) {
                    boolean merged = mergeInfo != null && mergeInfo.contains(revisionAsked) || selfInfo != null && selfInfo.contains(revisionAsked);
                    result = MergeCheckResult.getInstance(merged);
                } else {
                    Revision revision;
                    Target target;
                    if (actualRevision != targetRevisionCorrected) {
                        this.myMixedRevisionsFound = true;
                    }
                    if (actualRevision == targetRevisionCorrected) {
                        target = Target.on(pathFile, Revision.WORKING);
                        revision = Revision.WORKING;
                    } else {
                        target = Target.on(svnInfo.getUrl());
                        revision = Revision.of(targetRevisionCorrected);
                    }
                    PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, revision);
                    result = mergeinfoProperty == null ? this.goUp(revisionAsked, targetRevisionCorrected, branchRootPath, path, trunkUrl) : this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, trunkUrl, self);
                }
            }
        }
        return result;
    }

    @NotNull
    private MergeCheckResult processMergeinfoProperty(String pathWithRevisionNumber, long revisionAsked, @NotNull PropertyValue value, String trunkRelativeUrl, boolean self) throws SvnBindException {
        MergeCheckResult result;
        Map<String, MergeRangeList> mergedPathsMap = MergeRangeList.parseMergeInfo(value.toString());
        String mergedPathAffectingTrunkUrl = (String)ContainerUtil.find(mergedPathsMap.keySet(), path -> trunkRelativeUrl.startsWith((String)path));
        if (mergedPathAffectingTrunkUrl != null) {
            MergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingTrunkUrl);
            this.fillMergedRevisions(pathWithRevisionNumber, mergeRangeList);
            boolean isAskedRevisionMerged = ContainerUtil.or(mergeRangeList.getRanges(), range -> range.contains(revisionAsked) && (range.isInheritable() || self));
            result = MergeCheckResult.getInstance(isAskedRevisionMerged);
        } else {
            this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
            result = MergeCheckResult.NOT_MERGED;
        }
        return result;
    }

    private void fillMergedRevisions(String pathWithRevisionNumber, @NotNull MergeRangeList mergeRangeList) {
        HashSet revisions = new HashSet();
        HashSet nonInheritableRevisions = new HashSet();
        for (MergeRange range : mergeRangeList.getRanges()) {
            ContainerUtil.addAll(range.isInheritable() ? revisions : nonInheritableRevisions, (Iterable)range.getRevisions());
        }
        this.myPathMergedMap.put(pathWithRevisionNumber, revisions);
        if (!nonInheritableRevisions.isEmpty()) {
            this.myNonInheritablePathMergedMap.put(pathWithRevisionNumber, nonInheritableRevisions);
        }
    }

    public boolean isMixedRevisionsFound() {
        return this.myMixedRevisionsFound;
    }

    @NotNull
    public Collection<String> getNotMergedPaths(long number) {
        return this.myPartlyMerged.get((Object)number);
    }

    @NotNull
    private static Url appendPath(@NotNull Url url, @NotNull String path) {
        try {
            return url.appendPath(path, false);
        }
        catch (SvnBindException e) {
            ExceptionUtil.rethrow((Throwable)((Object)e));
            return null;
        }
    }
}

