/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.lock.LockClient;

public class CmdLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(@NotNull File file, boolean force, @NotNull String message, @Nullable ProgressTracker handler) throws VcsException {
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        parameters.add("--message");
        parameters.add(message);
        CommandExecutor command = this.execute(this.myVcs, Target.on(file), SvnCommandName.lock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.LOCKED, EventAction.LOCK_FAILED, handler);
    }

    @Override
    public void unlock(@NotNull File file, boolean force, @Nullable ProgressTracker handler) throws VcsException {
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        CommandExecutor command = this.execute(this.myVcs, Target.on(file), SvnCommandName.unlock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.UNLOCKED, EventAction.UNLOCK_FAILED, handler);
    }

    private static List<String> prepareParameters(@NotNull File file, boolean force) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static void handleCommandCompletion(@NotNull CommandExecutor command, @NotNull File file, @NotNull EventAction success, @NotNull EventAction failure, @Nullable ProgressTracker handler) throws VcsException {
        String error = SvnUtil.parseWarning(command.getErrorOutput());
        CmdLockClient.callHandler(handler, CmdLockClient.createEvent(file, error == null ? success : failure, error));
    }

    @NotNull
    private static ProgressEvent createEvent(@NotNull File file, @NotNull EventAction action, @Nullable String error) {
        return new ProgressEvent(file, -1L, null, null, action, error, null);
    }
}

