/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;

public class FirstInBranch {
    private static final Logger LOG = Logger.getInstance(FirstInBranch.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Url myAbsoluteBranchUrl;
    @NotNull
    private final Url myAbsoluteTrunkUrl;
    @NotNull
    private final Url myRepositoryRoot;

    public FirstInBranch(@NotNull SvnVcs vcs, @NotNull Url repositoryRoot, @NotNull Url branchUrl, @NotNull Url trunkUrl) {
        this.myVcs = vcs;
        this.myRepositoryRoot = repositoryRoot;
        this.myAbsoluteBranchUrl = branchUrl;
        this.myAbsoluteTrunkUrl = trunkUrl;
    }

    @Nullable
    public CopyData run() throws VcsException {
        Target trunk = Target.on(this.myAbsoluteTrunkUrl, Revision.HEAD);
        Target branch = Target.on(this.myAbsoluteBranchUrl, Revision.HEAD);
        CopyData result = this.find(new BranchPoint(trunk), new BranchPoint(branch), true);
        this.debug(result);
        return result;
    }

    @Nullable
    private CopyData find(@NotNull BranchPoint trunk, @NotNull BranchPoint branch, boolean isBranchFromTrunk) throws VcsException {
        CopyData result = null;
        this.debug(trunk, branch, isBranchFromTrunk);
        if (trunk.hasCopyPath()) {
            result = StringUtil.equals((CharSequence)trunk.copyPath(), (CharSequence)branch.relativePath()) ? trunk.toCopyData(!isBranchFromTrunk) : (branch.hasCopyPath() ? (branch.copyRevision() == trunk.copyRevision() ? (branch.revision() > trunk.revision() ? branch.toCopyData(isBranchFromTrunk) : trunk.toCopyData(!isBranchFromTrunk)) : (branch.copyRevision() > trunk.copyRevision() ? this.find(trunk, new BranchPoint(branch.copyTarget()), isBranchFromTrunk) : this.find(new BranchPoint(trunk.copyTarget()), branch, isBranchFromTrunk))) : this.find(branch, trunk, !isBranchFromTrunk));
        } else if (branch.hasCopyPath()) {
            result = StringUtil.equals((CharSequence)branch.copyPath(), (CharSequence)trunk.relativePath()) ? branch.toCopyData(isBranchFromTrunk) : this.find(trunk, new BranchPoint(branch.copyTarget()), isBranchFromTrunk);
        }
        return result;
    }

    private void debug(@Nullable CopyData copyData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found branch point " + StringUtil.join((Iterable)ContainerUtil.immutableList((Object[])new Object[]{this.myAbsoluteTrunkUrl.toDecodedString(), this.myAbsoluteBranchUrl.toDecodedString(), copyData}), (String)", "));
        }
    }

    private void debug(@NotNull BranchPoint trunk, @NotNull BranchPoint branch, boolean isBranchFromTrunk) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching branch point for " + StringUtil.join((Iterable)ContainerUtil.immutableList((Object[])new Object[]{trunk, branch, isBranchFromTrunk}), (String)", "));
        }
    }

    private class BranchPoint {
        @NotNull
        private final Target myTarget;
        @Nullable
        private LogEntry myEntry;
        @Nullable
        private LogEntryPath myPath;

        private BranchPoint(Target target) {
            this.myTarget = target;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.myTarget).add("revision", this.myEntry != null ? this.myEntry.getRevision() : -1L).add("path", this.myPath != null && this.myPath.getCopyPath() != null ? CommandUtil.format(this.myPath.getCopyPath(), Revision.of(this.myPath.getCopyRevision())) : null).toString();
        }

        private void init() throws VcsException {
            if (this.myEntry == null) {
                Pair<LogEntry, LogEntryPath> copyPoint = this.getCopyPoint();
                this.myEntry = (LogEntry)copyPoint.first;
                this.myPath = (LogEntryPath)copyPoint.second;
            }
        }

        @NotNull
        private Pair<LogEntry, LogEntryPath> getCopyPoint() throws VcsException {
            HistoryClient client = FirstInBranch.this.myVcs.getFactory(this.myTarget).createHistoryClient();
            Ref entry = Ref.create();
            client.doLog(this.myTarget, Revision.of(1L), this.myTarget.getPegRevision(), true, true, false, 1L, null, arg_0 -> ((Ref)entry).set(arg_0));
            if (entry.isNull()) {
                throw new VcsException("No branch point found for " + this.myTarget);
            }
            LogEntryPath path = ((LogEntry)entry.get()).getChangedPaths().get(this.relativePath());
            if (path == null) {
                throw new VcsException(this.myTarget + " not found in " + ((LogEntry)entry.get()).getChangedPaths());
            }
            return Pair.create((Object)entry.get(), (Object)path);
        }

        private boolean hasCopyPath() throws VcsException {
            this.init();
            return Objects.requireNonNull(this.myPath).getCopyPath() != null;
        }

        @NotNull
        private String copyPath() throws VcsException {
            this.init();
            return Objects.requireNonNull(this.myPath).getCopyPath();
        }

        private long copyRevision() throws VcsException {
            this.init();
            return Objects.requireNonNull(this.myPath).getCopyRevision();
        }

        @NotNull
        private Target copyTarget() throws VcsException {
            return Target.on(SvnUtil.append(FirstInBranch.this.myRepositoryRoot, this.copyPath()), Revision.of(this.copyRevision()));
        }

        @NotNull
        private String relativePath() {
            return SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(FirstInBranch.this.myRepositoryRoot, this.myTarget.getUrl()));
        }

        private long revision() throws VcsException {
            this.init();
            return Objects.requireNonNull(this.myEntry).getRevision();
        }

        @NotNull
        private CopyData toCopyData(boolean isBranchFromTrunk) throws VcsException {
            return new CopyData(this.copyRevision(), this.revision(), isBranchFromTrunk);
        }
    }
}

