/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingSelectionExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;

public class KeepingExpandedExpander
implements Expander {
    private final Expander mySelectionExpander;
    private final RepositoryBrowserComponent myBrowser;
    private Map<String, ChildrenData> myThirdLevel;
    private Collection<TreeNode> myExpanded;

    public KeepingExpandedExpander(RepositoryBrowserComponent browser, Expander selectionInstaller) {
        this.myBrowser = browser;
        this.mySelectionExpander = selectionInstaller;
    }

    public KeepingExpandedExpander(RepositoryBrowserComponent browser) {
        this(browser, new KeepingSelectionExpander(browser));
    }

    @Override
    public void onBeforeRefresh(RepositoryTreeNode node) {
        this.mySelectionExpander.onBeforeRefresh(node);
        this.myThirdLevel = new HashMap<String, ChildrenData>();
        this.myExpanded = new ArrayList<TreeNode>();
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)children.nextElement();
            if (!(treeNode instanceof RepositoryTreeNode)) continue;
            RepositoryTreeNode repositoryNode = (RepositoryTreeNode)treeNode;
            List<TreeNode> thirdLevelChildren = repositoryNode.getAllAlreadyLoadedChildren();
            String nodeName = repositoryNode.getSVNDirEntry().getName();
            if (thirdLevelChildren.isEmpty()) continue;
            boolean selfExpanded = this.myBrowser.isExpanded(repositoryNode);
            this.myThirdLevel.put(nodeName, new ChildrenData(selfExpanded, thirdLevelChildren, repositoryNode.getChildrenLoadState()));
            if (!selfExpanded) continue;
            this.myExpanded.addAll(this.myBrowser.getExpandedSubTree(repositoryNode));
        }
    }

    @Override
    public void onAfterRefresh(RepositoryTreeNode node) {
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            RepositoryTreeNode treeNode = (RepositoryTreeNode)children.nextElement();
            String name = treeNode.getSVNDirEntry().getName();
            ChildrenData thirdLevelLoaded = this.myThirdLevel.get(name);
            if (thirdLevelLoaded == null) continue;
            treeNode.setAlienChildren(thirdLevelLoaded.getChildren(), thirdLevelLoaded.getChildrenState());
            if (!thirdLevelLoaded.isExpanded()) continue;
            this.myBrowser.expandNode(treeNode);
        }
        for (TreeNode expandedNode : this.myExpanded) {
            this.myBrowser.expandNode(expandedNode);
        }
        this.mySelectionExpander.onAfterRefresh(node);
    }

    private static class ChildrenData {
        private final boolean myExpanded;
        private final List<TreeNode> myChildren;
        private final NodeLoadState myChildrenState;

        private ChildrenData(boolean expanded, List<TreeNode> children, NodeLoadState childrenState) {
            this.myExpanded = expanded;
            this.myChildren = children;
            this.myChildrenState = childrenState;
        }

        public List<TreeNode> getChildren() {
            return this.myChildren;
        }

        public NodeLoadState getChildrenState() {
            return this.myChildrenState;
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }
    }

    public static class Factory
    implements NotNullFunction<RepositoryBrowserComponent, Expander> {
        @NotNull
        public Expander fun(RepositoryBrowserComponent repositoryBrowserComponent) {
            return new KeepingExpandedExpander(repositoryBrowserComponent);
        }
    }
}

