/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.NotNullFunction;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.browserCache.CacheLoader;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingExpandedExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingSelectionExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;

public class RepositoryTreeModel
extends DefaultTreeModel
implements Disposable {
    private boolean myIsDisposed;
    private final SvnVcs myVCS;
    private boolean myIsShowFiles;
    private final Loader myCacheLoader;
    private final RepositoryBrowserComponent myBrowser;
    private NotNullFunction<RepositoryBrowserComponent, Expander> myDefaultExpanderFactory;

    public RepositoryTreeModel(@NotNull SvnVcs vcs, boolean showFiles, RepositoryBrowserComponent browser) {
        super(null);
        this.myVCS = vcs;
        this.myIsShowFiles = showFiles;
        this.myBrowser = browser;
        this.myCacheLoader = CacheLoader.getInstance();
        this.myDefaultExpanderFactory = new KeepingExpandedExpander.Factory();
    }

    public boolean isShowFiles() {
        return this.myIsShowFiles;
    }

    public void setShowFiles(boolean showFiles) {
        this.myIsShowFiles = showFiles;
    }

    public void setRoots(Url[] urls) {
        RepositoryTreeRootNode rootNode = new RepositoryTreeRootNode(this, urls);
        Disposer.register((Disposable)this, (Disposable)rootNode);
        this.setRoot(rootNode);
    }

    public void setSingleRoot(Url url) {
        RepositoryTreeNode rootNode = new RepositoryTreeNode(this, null, url, url);
        Disposer.register((Disposable)this, (Disposable)rootNode);
        this.setRoot(rootNode);
    }

    private boolean hasRoot(Url url) {
        if (this.getRoot() instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)this.getRoot()).getUserObject().equals(url);
        }
        RepositoryTreeRootNode root = (RepositoryTreeRootNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            RepositoryTreeNode node = (RepositoryTreeNode)root.getChildAt(i);
            if (!node.getUserObject().equals(url)) continue;
            return true;
        }
        return false;
    }

    public TreeNode[] getPathToSubRoot(TreeNode node) {
        TreeNode[] path = this.getPathToRoot(node);
        TreeNode[] result = new TreeNode[path.length - 1];
        System.arraycopy(path, 1, result, 0, path.length - 1);
        return result;
    }

    public void addRoot(Url url) {
        if (!this.hasRoot(url)) {
            ((RepositoryTreeRootNode)this.getRoot()).addRoot(url);
        }
    }

    public void removeRoot(Url url) {
        RepositoryTreeRootNode root = (RepositoryTreeRootNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            RepositoryTreeNode node = (RepositoryTreeNode)root.getChildAt(i);
            if (!node.getUserObject().equals(url)) continue;
            root.remove(node);
        }
    }

    public SvnVcs getVCS() {
        return this.myVCS;
    }

    public void dispose() {
        this.myIsDisposed = true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public Loader getCacheLoader() {
        return this.myCacheLoader;
    }

    @NotNull
    public Expander getLazyLoadingExpander() {
        return (Expander)this.myDefaultExpanderFactory.fun((Object)this.myBrowser);
    }

    @NotNull
    public Expander getSelectionKeepingExpander() {
        return new KeepingSelectionExpander(this.myBrowser);
    }

    public void setDefaultExpanderFactory(NotNullFunction<RepositoryBrowserComponent, Expander> defaultExpanderFactory) {
        this.myDefaultExpanderFactory = defaultExpanderFactory;
    }

    @Nullable
    public RepositoryTreeNode findByUrl(RepositoryTreeNode oldNode) {
        TreeNode root;
        if (oldNode.getParent() == null) {
            return oldNode;
        }
        TreeNode[] oldPath = this.getPathToRoot(oldNode);
        if (!(oldPath[0] instanceof RepositoryTreeNode)) {
            TreeNode[] result = new TreeNode[oldPath.length - 1];
            System.arraycopy(oldPath, 1, result, 0, oldPath.length - 1);
            oldPath = result;
        }
        if (!((root = (TreeNode)this.getRoot()) instanceof RepositoryTreeNode)) {
            Enumeration<? extends TreeNode> children = root.children();
            root = null;
            while (children.hasMoreElements()) {
                TreeNode node = children.nextElement();
                if (!(node instanceof RepositoryTreeNode) || !((RepositoryTreeNode)node).getURL().equals(((RepositoryTreeNode)oldPath[0]).getURL())) continue;
                root = node;
                break;
            }
        } else if (root == null || !((RepositoryTreeNode)root).getURL().equals(((RepositoryTreeNode)oldPath[0]).getURL())) {
            return null;
        }
        if (root == null) {
            return null;
        }
        for (int i = 1; i < oldPath.length; ++i) {
            TreeNode treeNode = oldPath[i];
            if (root == null) {
                return null;
            }
            root = this.getChild((RepositoryTreeNode)root, ((RepositoryTreeNode)treeNode).getURL());
        }
        return (RepositoryTreeNode)root;
    }

    @Nullable
    private RepositoryTreeNode getChild(RepositoryTreeNode node, Url url) {
        List<RepositoryTreeNode> children = node.getAlreadyLoadedChildren();
        for (RepositoryTreeNode child : children) {
            if (!child.getURL().equals(url)) continue;
            return child;
        }
        return null;
    }
}

