/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum ConflictAction {
    EDIT("edit", "edited"),
    ADD("add", "added"),
    DELETE("delete", "deleted"),
    REPLACE("replace", "replaced");

    @NotNull
    private static final Map<String, ConflictAction> ourAllActions;
    @NotNull
    private final String myKey;
    private final String @NotNull [] myOtherKeys;

    private ConflictAction(String key, String ... otherKeys) {
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull ConflictAction action) {
        ourAllActions.put(action.myKey, action);
        for (String otherKey : action.myOtherKeys) {
            ourAllActions.put(otherKey, action);
        }
    }

    @NotNull
    public static ConflictAction from(@NotNull String actionName) {
        ConflictAction result = ourAllActions.get(actionName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown conflict action " + actionName);
        }
        return result;
    }

    static {
        ourAllActions = new HashMap<String, ConflictAction>();
        for (ConflictAction action : ConflictAction.values()) {
            ConflictAction.register(action);
        }
    }
}

