/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCategory;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SystemInfo.isWindows && EnvironmentUtil.getValue((String)"SVN_ASP_DOT_NET_HACK") != null ? "_svn" : ".svn";
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final AtomicNotNullLazyValue<Path> USER_CONFIGURATION_PATH = AtomicNotNullLazyValue.createValue(() -> SystemInfo.isWindows ? Paths.get(Objects.requireNonNull(EnvironmentUtil.getValue((String)"APPDATA")), "Subversion") : Paths.get(SystemProperties.getUserHome(), ".subversion"));
    public static final AtomicNotNullLazyValue<Path> SYSTEM_CONFIGURATION_PATH = AtomicNotNullLazyValue.createValue(() -> SystemInfo.isWindows ? Paths.get(Objects.requireNonNull(EnvironmentUtil.getValue((String)"ALLUSERSPROFILE")), "Application Data", "Subversion") : Paths.get("/etc/subversion", new String[0]));
    private static final Logger LOG = Logger.getInstance(SvnUtil.class);
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);
    private static final Pair<Url, WorkingCopyFormat> UNKNOWN_REPOSITORY_AND_FORMAT = Pair.create(null, (Object)((Object)WorkingCopyFormat.UNKNOWN));

    private SvnUtil() {
    }

    @Nullable
    public static String parseWarning(@NotNull String text) {
        Matcher matcher = WARNING_PATTERN.matcher(text);
        return matcher.find() ? matcher.group() : null;
    }

    @Nullable
    public static Date parseDate(@Nullable String value) {
        return SvnUtil.parseDate(value, true);
    }

    @Nullable
    public static Date parseDate(@Nullable String value, boolean logError) {
        if (value == null) {
            return null;
        }
        try {
            return Date.from(Instant.parse(value));
        }
        catch (ArithmeticException | DateTimeParseException e) {
            if (logError) {
                LOG.error("Could not parse date " + value, (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isSvnVersioned(@NotNull SvnVcs vcs, @NotNull File file) {
        return vcs.getInfo(file) != null;
    }

    @NotNull
    public static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull File path, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path);
        return file != null ? SvnUtil.crawlWCRoots(vcs, file, callback, progress) : Collections.emptyList();
    }

    @NotNull
    private static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile parent;
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        VirtualFile virtualFile = parent = !file.isDirectory() || !file.isValid() ? file.getParent() : file;
        if (SvnUtil.isSvnVersioned(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)parent))) {
            SvnUtil.checkCanceled(progress);
            callback.handleWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)file), progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (file.isDirectory()) {
            SvnUtil.checkCanceled(progress);
            for (VirtualFile child : parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!child.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(vcs, child, callback, progress));
            }
        }
        return result;
    }

    private static void checkCanceled(@Nullable ProgressIndicator progress) {
        ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progress);
    }

    public static File @NotNull [] toIoFiles(VirtualFile @NotNull [] files) {
        return (File[])ContainerUtil.map2Array((Object[])files, File.class, VfsUtilCore::virtualToIoFile);
    }

    public static void doLockFiles(Project project, SvnVcs activeVcs, File @NotNull [] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1);
            if (!dialog.showAndGet()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.LOCK_FAILED) {
                    failedLocks.add(ObjectUtils.notNull((Object)event.getErrorMessage(), (Object)event.getFile().getAbsolutePath()));
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtilRt.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, SvnVcs activeVcs, File[] ioFiles) throws VcsException {
        boolean force = true;
        VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(ObjectUtils.notNull((Object)event.getErrorMessage(), (Object)event.getFile().getAbsolutePath()));
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtilRt.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    @NotNull
    public static MultiMap<Pair<Url, WorkingCopyFormat>, Change> splitChangesIntoWc(@NotNull SvnVcs vcs, @NotNull List<? extends Change> changes) {
        return SvnUtil.splitIntoRepositoriesMap(vcs, changes, change -> ChangesUtil.getFilePath((Change)change));
    }

    @NotNull
    public static <T> MultiMap<Pair<Url, WorkingCopyFormat>, T> splitIntoRepositoriesMap(@NotNull SvnVcs vcs, @NotNull Collection<? extends T> items, @NotNull Convertor<? super T, ? extends FilePath> converter) {
        return ContainerUtil.groupBy(items, item -> {
            RootUrlInfo path = vcs.getSvnFileUrlMapping().getWcRootForFilePath((FilePath)converter.convert(item));
            return path == null ? UNKNOWN_REPOSITORY_AND_FORMAT : Pair.create((Object)path.getRepositoryUrl(), (Object)((Object)path.getFormat()));
        });
    }

    @NotNull
    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new SqLiteJdbcWorkingCopyFormatOperation(dbFile)))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        return result != null ? result : WorkingCopyFormat.UNKNOWN;
    }

    private static void notifyDatabaseError() {
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification("Some errors occurred while accessing svn working copy database.", NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        Info info2 = vcs.getInfo(file);
        return info2 != null ? info2.getRepositoryId() : null;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, Url url) {
        try {
            Info info2 = vcs.getInfo(url, Revision.UNDEFINED);
            return info2 == null ? null : info2.getRepositoryId();
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, File file) {
        Info info2 = vcs.getInfo(file);
        return info2 != null ? info2.getRepositoryRootUrl() : null;
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SvnUtil.createUrl(url));
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, Url url) throws SvnBindException {
        Info info2 = vcs.getInfo(url, Revision.HEAD);
        return info2 == null ? null : info2.getRepositoryRootUrl();
    }

    public static boolean isWorkingCopyRoot(@NotNull File file) {
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRoot(file));
    }

    public static boolean isWorkingCopyRoot(@NotNull VirtualFile file) {
        VirtualFile adminDir = file.findChild(SVN_ADMIN_DIR_NAME);
        return adminDir != null && adminDir.findChild(WC_DB_FILE_NAME) != null;
    }

    @NotNull
    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileByUrl(path));
    }

    @Deprecated
    @Nullable
    public static Url getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull String urlValue) {
        Url url = null;
        try {
            url = SvnUtil.createUrl(urlValue);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return url != null ? SvnUtil.getBranchForUrl(vcs, vcsRoot, url) : null;
    }

    @Nullable
    public static Url getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull Url url) {
        Url result = null;
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
        try {
            result = configuration.getWorkingBranch(url);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    public static boolean checkRepositoryVersion15(@NotNull SvnVcs vcs, @NotNull Url url) {
        boolean result = false;
        try {
            result = vcs.getFactory().createRepositoryFeaturesClient().supportsMergeTracking(url);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    @Nullable
    public static Status getStatus(@NotNull SvnVcs vcs, @NotNull File file) {
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @NotNull
    public static Depth getDepth(SvnVcs vcs, File file) {
        Info info2 = vcs.getInfo(file);
        return info2 != null && info2.getDepth() != null ? info2.getDepth() : Depth.UNKNOWN;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        VirtualFile child = file.findChild(SVN_ADMIN_DIR_NAME);
        return child != null && child.isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Url getUrl(SvnVcs vcs, File file) {
        Info info2 = vcs.getInfo(file);
        return info2 == null ? null : info2.getUrl();
    }

    public static boolean remoteFolderIsEmpty(@NotNull SvnVcs vcs, @NotNull String url) throws VcsException {
        Target target = Target.on(SvnUtil.createUrl(url));
        Ref result = new Ref((Object)true);
        DirectoryEntryConsumer handler = entry -> {
            if (entry != null) {
                result.set((Object)false);
            }
        };
        vcs.getFactory(target).createBrowseClient().list(target, null, Depth.IMMEDIATES, handler);
        return (Boolean)result.get();
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    @Nullable
    public static File getWorkingCopyRoot(@NotNull File file) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return null;
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? current : null;
    }

    @Nullable
    public static VirtualFile getWorkingCopyRoot(@NotNull VirtualFile file) {
        do {
            if (!SvnUtil.isWorkingCopyRoot(file)) continue;
            return file;
        } while ((file = file.getParent()) != null);
        return null;
    }

    @Deprecated
    @Nullable
    public static File getWorkingCopyRootNew(@NotNull File file) {
        return SvnUtil.getWorkingCopyRoot(file);
    }

    @Nullable
    public static File getParentWithDb(@NotNull File file) {
        File current;
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static boolean isAncestor(@NotNull Url parentUrl, @NotNull Url childUrl) {
        return Url.isAncestor(parentUrl.toDecodedString(), childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull Url parentUrl, @NotNull Url childUrl) {
        return SvnUtil.getRelativeUrl(parentUrl.toDecodedString(), childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull Target parent, @NotNull Target child) {
        return SvnUtil.getRelativeUrl(SvnUtil.toDecodedString(parent), SvnUtil.toDecodedString(child));
    }

    private static String getRelativeUrl(@NotNull String parentUrl, @NotNull String childUrl) {
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(@NotNull String parentPath, @NotNull String childPath) {
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    @NotNull
    @Contract(pure=true)
    public static String ensureStartSlash(@NotNull String path) {
        return StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : '/' + path;
    }

    @NotNull
    public static String join(String ... parts) {
        return StringUtil.join((String[])parts, (String)"/");
    }

    @NotNull
    public static Url removePathTail(@NotNull Url url) throws SvnBindException {
        return SvnUtil.createUrl(Url.removeTail(url.toDecodedString()), false);
    }

    @NotNull
    public static Revision getHeadRevision(@NotNull SvnVcs vcs, @NotNull Url url) throws SvnBindException {
        Info info2 = vcs.getInfo(url, Revision.HEAD);
        if (info2 == null) {
            throw new SvnBindException("Could not get info for " + url);
        }
        if (!info2.getRevision().isValid()) {
            throw new SvnBindException("Could not get revision for " + url);
        }
        return info2.getRevision();
    }

    public static byte[] getFileContents(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable Revision revision, @Nullable Revision pegRevision) throws VcsException {
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    @NotNull
    public static Url createUrl(@NotNull String url) throws SvnBindException {
        return SvnUtil.createUrl(url, true);
    }

    @NotNull
    public static Url createUrl(@NotNull String url, boolean encoded) throws SvnBindException {
        return Url.parse(url, encoded);
    }

    @NotNull
    public static Url parseUrl(@NotNull String url) {
        try {
            return SvnUtil.createUrl(url);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
    }

    @NotNull
    public static Url parseUrl(@NotNull String url, boolean encoded) {
        try {
            return SvnUtil.createUrl(url, encoded);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
    }

    @NotNull
    public static Url append(@NotNull Url parent, @NotNull String child) throws SvnBindException {
        return SvnUtil.append(parent, child, false);
    }

    @NotNull
    public static Url append(@NotNull Url parent, @NotNull String child, boolean encoded) throws SvnBindException {
        return parent.appendPath(child, encoded);
    }

    @NotNull
    public static IllegalArgumentException createIllegalArgument(@NotNull Exception e) {
        return new IllegalArgumentException(e);
    }

    @Nullable
    public static String getChangelistName(@NotNull Status status) {
        return status.getNodeKind().isFile() ? status.getChangeListName() : null;
    }

    public static boolean isUnversionedOrNotFound(@NotNull SvnBindException e) {
        return e.contains(ErrorCode.WC_PATH_NOT_FOUND) || e.contains(ErrorCode.UNVERSIONED_RESOURCE) || e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.ILLEGAL_TARGET) || StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"(not a versioned resource)");
    }

    public static boolean isAuthError(@NotNull SvnBindException e) {
        return e.contains(ErrorCode.RA_NOT_AUTHORIZED) || e.contains(ErrorCode.RA_UNKNOWN_AUTH) || e.containsCategory(ErrorCategory.AUTHZ) || e.containsCategory(ErrorCategory.AUTHN);
    }

    @NotNull
    public static Target append(@NotNull Target target, @NotNull String path) throws SvnBindException {
        return SvnUtil.append(target, path, false);
    }

    @NotNull
    public static Target append(@NotNull Target target, @NotNull String path, boolean checkAbsolute) throws SvnBindException {
        Target result = target.isFile() ? Target.on(SvnUtil.resolvePath(target.getFile(), path)) : Target.on(checkAbsolute && URI.create(path).isAbsolute() ? SvnUtil.createUrl(path) : SvnUtil.append(target.getUrl(), path));
        return result;
    }

    @NotNull
    public static File resolvePath(@NotNull File base, @NotNull String path) {
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        return result;
    }

    @NotNull
    public static String toDecodedString(@NotNull Target target) {
        return target.isFile() ? target.getFile().getPath() : target.getUrl().toDecodedString();
    }

    private static class SqLiteJdbcWorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        private static final String SQLITE_JDBC_TEMP_DIR_PROPERTY = "org.sqlite.tmpdir";
        @NotNull
        private final File myDbFile;

        SqLiteJdbcWorkingCopyFormatOperation(@NotNull File dbFile) {
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            Connection connection = null;
            int userVersion = 0;
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)this.myDbFile.getPath()));
                ResultSet resultSet = connection.createStatement().executeQuery("pragma user_version");
                if (resultSet.next()) {
                    userVersion = resultSet.getInt(1);
                } else {
                    LOG.info("No result while getting user version for " + this.myDbFile.getPath());
                }
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            catch (ClassNotFoundException | SQLException e) {
                LOG.info((Throwable)e);
            }
            finally {
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }

        private static void ensureTempFolder() {
            if (System.getProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY) == null) {
                System.setProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY, PathManager.getTempPath());
            }
        }

        private static void close(@Nullable Connection connection) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    SvnUtil.notifyDatabaseError();
                }
            }
        }

        static {
            SqLiteJdbcWorkingCopyFormatOperation.ensureTempFolder();
        }
    }
}

