/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.JsCode;
import org.jetbrains.kotlin.ir.backend.js.JsIrCompilationError;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.js.config.DceRuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager performanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    @NotNull
    private static final Map<String, ProduceKind> produceMap;

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        void $this$filterTo$iv$iv22;
        void $this$mapTo$iv$iv;
        File file2;
        String string2;
        Object[] commonSourcesArray;
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v0;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block42: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment);
                projectEnv.registerExtensionsFromPlugins(configuration);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances((Project)mockProject);
                Iterable iterable = scriptingEvaluators;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl3 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v0 = t;
                    break block42;
                }
                v0 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v0;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            boolean projectEnv = false;
            boolean scriptingEvaluators = false;
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull((Object)arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.REPOSITORIES, repositories);
        Object[] objectArray = commonSourcesArray = arguments2.getCommonSources();
        Set set = objectArray == null ? null : ArraysKt.toSet((Object[])objectArray);
        Set commonSources = set == null ? SetsKt.emptySet() : set;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            CharSequence it = arguments2.getIncludes();
            boolean bl3 = false;
            boolean bl = false;
            if (it == null || it.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String bl3 = arguments2.getIrModuleName();
        if (bl3 == null) {
            String string3 = FileUtil.getNameWithoutExtension((File)outputFile);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(outputFile)");
            string2 = string3;
        } else {
            string2 = bl3;
        }
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, string2);
        JsConfig config = new JsConfig(projectJs, configurationJs);
        File file3 = outputFile.getParentFile();
        if (file3 == null) {
            File file4 = outputFile.getAbsoluteFile().getParentFile();
            Intrinsics.checkNotNull((Object)file4);
            file2 = file4;
        } else {
            file2 = file3;
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        Object object = configuration.get(JSConfigurationKeys.REPOSITORIES);
        Object object2 = object == null ? (Collection)CollectionsKt.emptyList() : object;
        MessageCollector messageCollector3 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector3 == null) {
            String string4 = "Could not find message collector";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        object = messageCollector3;
        KotlinLibraryResolveResult resolvedLibraries = JsLibraryResolverKt.jsResolveLibraries((List)libraries, (Collection)object2, (Logger)K2JsIrCompilerKt.messageCollectorLogger((MessageCollector)object));
        Iterable $this$map$iv = friendLibraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string6 = new File((String)it).getAbsolutePath();
            collection.add(string6);
        }
        List friendAbsolutePaths = (List)destination$iv$iv;
        Object $this$filter$iv2 = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv22) {
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            boolean bl6 = false;
            if (!friendAbsolutePaths.contains(it.getLibraryFile().getAbsolutePath())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List friendDependencies = (List)destination$iv$iv2;
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            if (arguments2.getIrProduceKlibFile()) {
                boolean $this$filter$iv2 = Intrinsics.areEqual((Object)FilesKt.getExtension((File)outputFile), (Object)"klib");
                $i$f$filter = false;
                boolean $this$filterTo$iv$iv22 = false;
                if (!$this$filter$iv2) {
                    boolean bl4 = false;
                    String $this$filterTo$iv$iv22 = "Please set up .klib file as output";
                    throw (Throwable)new IllegalArgumentException($this$filterTo$iv$iv22.toString());
                }
            }
            try {
                $this$filter$iv2 = config.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv2, (String)"config.project");
                Iterable iterable3 = $this$filter$iv2;
                $this$filter$iv2 = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv2, (String)"config.configuration");
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport((CompilerConfiguration)$this$filter$iv2);
                $this$filter$iv2 = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv2, (String)"config.configuration");
                Object object3 = $this$filter$iv2;
                IrFactory irFactory = PersistentIrFactory.INSTANCE;
                $this$filter$iv2 = outputFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv2, (String)"outputFile.path");
                KlibKt.generateKLib((Project)iterable3, sourcesFiles, (AbstractAnalyzerWithCompilerReport)abstractAnalyzerWithCompilerReport, (CompilerConfiguration)object3, (KotlinLibraryResolveResult)resolvedLibraries, (List)friendDependencies, (IrFactory)irFactory, (String)$this$filter$iv2, (boolean)arguments2.getIrProduceKlibDir());
            }
            catch (JsIrCompilationError e) {
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getIrProduceJs()) {
            JsCode jsCode;
            JsCode e2;
            AnalyzerWithCompilerReport outputWasmFile2;
            Object outputWatFile;
            MainModule mainModule;
            MainModule mainModule2;
            boolean bl;
            Object element$iv$iv;
            Object item$iv$iv;
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig(JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
            String includes = arguments2.getIncludes();
            if (includes != null) {
                Object v8;
                block43: {
                    Collection bl4 = sourcesFiles;
                    $i$f$filterTo = false;
                    if (!bl4.isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                    }
                    List allLibraries = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
                    element$iv$iv = allLibraries;
                    boolean bl5 = false;
                    Object bl6 = element$iv$iv;
                    bl = false;
                    Iterator iterator2 = bl6.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        KotlinLibrary it = (KotlinLibrary)t;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it.getLibraryFile().getAbsolutePath(), (Object)new File(includes).getAbsolutePath())) continue;
                        v8 = t;
                        break block43;
                    }
                    v8 = null;
                }
                item$iv$iv = v8;
                Intrinsics.checkNotNull((Object)item$iv$iv);
                Object mainLib = item$iv$iv;
                mainModule2 = (MainModule)new MainModule.Klib((KotlinLibrary)mainLib);
            } else {
                mainModule2 = mainModule = (MainModule)new MainModule.SourceFiles(sourcesFiles);
            }
            if (arguments2.getWasm()) {
                CompilerConfiguration mainLib = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)mainLib, (String)"config.configuration");
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport(mainLib);
                mainLib = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)mainLib, (String)"config.configuration");
                WasmCompilerResult res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm((Project)projectJs, (MainModule)mainModule, (AbstractAnalyzerWithCompilerReport)abstractAnalyzerWithCompilerReport, (CompilerConfiguration)mainLib, (PhaseConfig)new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), (KotlinLibraryResolveResult)resolvedLibraries, (List)friendDependencies, (Set)SetsKt.setOf((Object)new FqName("main")));
                item$iv$iv = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wasm");
                Intrinsics.checkNotNull((Object)item$iv$iv);
                Object outputWasmFile2 = item$iv$iv;
                FilesKt.writeBytes((File)outputWasmFile2, (byte[])res2.getWasm());
                element$iv$iv = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wat");
                Intrinsics.checkNotNull((Object)element$iv$iv);
                outputWatFile = element$iv$iv;
                FilesKt.writeText$default((File)outputWatFile, (String)res2.getWat(), null, (int)2, null);
                String runner = kotlin.text.StringsKt.trimIndent((String)("\n                    const wasmBinary = read(String.raw`" + ((File)outputWasmFile2).getAbsoluteFile() + "`, 'binary');\n                    const wasmModule = new WebAssembly.Module(wasmBinary);\n                    const wasmInstance = new WebAssembly.Instance(wasmModule, { runtime, js_code });\n                    wasmInstance.exports.main();\n                "));
                FilesKt.writeText$default((File)outputFile, (String)(res2.getJs() + '\n' + runner), null, (int)2, null);
                return ExitCode.OK;
            }
            try {
                outputWatFile = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)outputWatFile, (String)"config.configuration");
                outputWasmFile2 = new AnalyzerWithCompilerReport((CompilerConfiguration)outputWatFile);
                outputWatFile = config.getConfiguration();
                boolean runner = !arguments2.getIrDce();
                boolean bl8 = arguments2.getIrDce();
                DceRuntimeDiagnostic bl6 = K2JsIrCompilerKt.resolve(DceRuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector2);
                bl = arguments2.getIrDceDriven();
                boolean bl9 = arguments2.getIrPerModule();
                boolean bl10 = arguments2.getIrPropertyLazyInitialization();
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = outputWasmFile2;
                Intrinsics.checkNotNullExpressionValue((Object)outputWatFile, (String)"configuration");
                outputWasmFile2 = CompilerKt.compile$default((Project)projectJs, (MainModule)mainModule, (AbstractAnalyzerWithCompilerReport)abstractAnalyzerWithCompilerReport, (CompilerConfiguration)outputWatFile, (PhaseConfig)phaseConfig, (KotlinLibraryResolveResult)resolvedLibraries, (List)friendDependencies, (List)mainCallArguments, null, (boolean)runner, (boolean)bl8, (boolean)bl, (DceRuntimeDiagnostic)bl6, (boolean)false, (boolean)bl9, (boolean)true, (boolean)bl10, (int)8448, null);
            }
            catch (JsIrCompilationError e2) {
                return ExitCode.COMPILATION_ERROR;
            }
            AnalyzerWithCompilerReport compiledModule = outputWasmFile2;
            if (arguments2.getIrDce() && !arguments2.getIrDceDriven()) {
                e2 = compiledModule.getDceJsCode();
                Intrinsics.checkNotNull((Object)e2);
                jsCode = e2;
            } else {
                e2 = compiledModule.getJsCode();
                Intrinsics.checkNotNull((Object)e2);
                jsCode = e2;
            }
            JsCode jsCode2 = jsCode;
            FilesKt.writeText$default((File)outputFile, (String)jsCode2.getMainModule(), null, (int)2, null);
            Iterable $this$forEach$iv = jsCode2.getDependencies();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $dstr$name$content = (Pair)element$iv;
                boolean bl11 = false;
                String name = (String)$dstr$name$content.component1();
                String content = (String)$dstr$name$content.component2();
                FilesKt.writeText$default((File)FilesKt.resolveSibling((File)outputFile, (String)Intrinsics.stringPlus((String)name, (Object)".js")), (String)content, null, (int)2, null);
            }
            if (arguments2.getGenerateDts()) {
                Object object4 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "d.ts");
                Intrinsics.checkNotNull((Object)object4);
                File dtsFile = object4;
                object4 = compiledModule.getTsDefinitions();
                if (object4 == null) {
                    String string7 = "No ts definitions";
                    boolean bl12 = false;
                    throw (Throwable)new IllegalStateException(string7.toString());
                }
                FilesKt.writeText$default((File)dtsFile, (String)object4, null, (int)2, null);
            }
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        String moduleKindName;
        ModuleKind moduleKind;
        String $this$filterNotTo$iv$iv;
        boolean $i$f$filterNotTo;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull((Object)string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = Intrinsics.stringPlus((String)"Unsupported ECMA version: ", (Object)string2);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22));
            }
        }
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map argument is not supported yet", null);
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNot$iv;
            List list2;
            Object object;
            Iterable $this$dropLastWhile$iv;
            Object $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = friendModules;
            String string3 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
            int n = 0;
            string3 = new Regex(string3);
            n = 0;
            boolean bl = false;
            $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = string3.split((CharSequence)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl3 = false;
                    object = it;
                    boolean bl4 = false;
                    if (object.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterNotTo = false;
            object = $this$filterNotTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence charSequence = it;
                boolean bl6 = false;
                if (charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        $this$filterNotTo$iv$iv = arguments2.getErrorTolerancePolicy();
        if ($this$filterNotTo$iv$iv == null) {
            errorTolerancePolicy = null;
        } else {
            destination$iv$iv = $this$filterNotTo$iv$iv;
            $i$f$filterNotTo = false;
            boolean bl = false;
            Object it = destination$iv$iv;
            boolean bl7 = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy((String)it);
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        $this$filterNotTo$iv$iv = errorTolerancePolicy2;
        if (Intrinsics.areEqual((Object)($this$filterNotTo$iv$iv == null ? null : Boolean.valueOf(((ErrorTolerancePolicy)((Object)$this$filterNotTo$iv$iv)).getAllowErrors())), (Object)true)) {
            configuration.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection)sourceMapContentEmbeddingMap.keySet(), (String)", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        int[] nArray = new int[versionArray.length];
        System.arraycopy(versionArray, 0, nArray, 0, versionArray.length);
        return new KlibMetadataVersion(nArray);
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD))};
        moduleKindMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))};
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(null, (Object)((Object)ProduceKind.DEFAULT)), TuplesKt.to((Object)"js", (Object)((Object)ProduceKind.JS)), TuplesKt.to((Object)"klib", (Object)((Object)ProduceKind.KLIB))};
        produceMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile = file2.getVirtualFile();
                String string2 = virtualFile != null ? MessageUtil.virtualFileToPath(virtualFile) : Intrinsics.stringPlus((String)file2.getName(), (Object)" (no virtual file)");
                collection.add(string2);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, Intrinsics.stringPlus((String)"Compiling source files: ", (Object)StringsKt.join(fileNames, ", ")), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            String string2 = libraryString;
            return string2 == null ? CollectionsKt.emptyList() : this.splitByPathSeparator(string2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string2.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    int n2 = 0;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence3 = it;
                boolean bl4 = false;
                if (charSequence3.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

