/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.stats.MemoryProbe;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.sync.NativeWorkspaceImpl;
import com.android.tools.ndk.sync.NativeWorkspaceModifier;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleCppSyncStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0017J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "nativeWorkspaceModifiers", "", "Lcom/android/tools/ndk/sync/NativeWorkspaceModifier;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "nativeModuleStats", "", "Lcom/google/wireless/android/sdk/stats/GradleCppSyncStats$NativeModuleStats;", "nativeWorkspace", "Lcom/android/tools/ndk/sync/NativeWorkspaceImpl;", "startedMs", "", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "android-ndk"})
public final class NativeWorkspaceModificationTask
extends Task.Backgroundable {
    private long startedMs;
    private final List<GradleCppSyncStats.NativeModuleStats> nativeModuleStats;
    private final NativeWorkspaceImpl nativeWorkspace;
    private final Collection<NativeWorkspaceModifier> nativeWorkspaceModifiers;
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        this.startedMs = System.currentTimeMillis();
        indicator.setIndeterminate(true);
        Iterable $this$groupBy$iv = this.nativeWorkspaceModifiers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            NativeWorkspaceModifier it = (NativeWorkspaceModifier)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getModule();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv.forEach((BiConsumer)new BiConsumer<String, List<? extends NativeWorkspaceModifier>>(this){
            final /* synthetic */ NativeWorkspaceModificationTask this$0;

            public final void accept(@NotNull String module, @NotNull List<? extends NativeWorkspaceModifier> modifiers) {
                NativeWorkspaceModificationTask.access$getNativeWorkspace$p(this.this$0).setModule(module);
                Iterable $this$forEach$iv = modifiers;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NativeWorkspaceModifier it = (NativeWorkspaceModifier)element$iv;
                    boolean bl = false;
                    it.modify(NativeWorkspaceModificationTask.access$getNativeWorkspace$p(this.this$0));
                }
                Collection collection = NativeWorkspaceModificationTask.access$getNativeModuleStats$p(this.this$0);
                GradleCppSyncStats.NativeModuleStats nativeModuleStats = NativeWorkspaceModificationTask.access$getNativeWorkspace$p(this.this$0).getStatsForCurrentModule();
                boolean bl = false;
                collection.add(nativeModuleStats);
            }
            {
                this.this$0 = nativeWorkspaceModificationTask;
            }
        });
        this.nativeWorkspace.preCommit(indicator);
    }

    @UiThread
    public void onFinished() {
        boolean hasNative;
        super.onFinished();
        this.nativeWorkspace.dispose();
        Collection collection = NdkHelper.getNativeModules(this.getProject());
        boolean bl = false;
        boolean bl2 = hasNative = !collection.isEmpty();
        if (hasNative) {
            long syncTimeMs = System.currentTimeMillis() - this.startedMs;
            logger.info("Updating model took " + (double)this.startedMs / 1000.0 + 's');
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED);
            boolean bl3 = false;
            boolean bl4 = false;
            AndroidStudioEvent.Builder $this$apply = builder;
            boolean bl5 = false;
            GradleCppSyncStats.Builder builder2 = $this$apply.getGradleCppSyncStatsBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            GradleCppSyncStats.Builder $this$apply2 = builder2;
            boolean bl8 = false;
            $this$apply2.setNativeWorkspaceSyncTimeMs(syncTimeMs);
            $this$apply2.addAllSyncedNativeModuleStats((Iterable)this.nativeModuleStats);
            if (Random.Default.nextInt(100) == 0) {
                long size = new MemoryProbe(CollectionsKt.listOf((Object[])new String[]{"com.jetbrains.cidr.lang.", String.class.getPackage().getName() + ".", File.class.getPackage().getName() + ".", com.google.common.collect.ImmutableList.class.getPackage().getName() + ".", ImmutableList.class.getPackage().getName() + ".", List.class.getPackage().getName() + ".", Object.class.getPackage().getName() + ".", ArrayList.class.getPackage().getName() + "."}), null, null, null, 14, null).check((Object)OCWorkspace.getInstance((Project)this.getProject()));
                $this$apply2.setCidrWorkspaceSize((int)size);
                logger.info("OCWorkspace size = " + (double)size / 1024.0 / 1024.0 + "MiB");
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder, (Project)this.getProject()));
        } else {
            logger.info("NDK support for project '" + this.getProject().getName() + "' is disabled because the project doesn't contain any valid native configurations.");
        }
        NdkProjectInfo.get((Project)this.getProject()).setHasNdkModules(hasNative);
        NdkHelper.disableCppLanguageSupport(this.getProject(), !hasNative);
    }

    @UiThread
    public void onSuccess() {
        super.onSuccess();
        if (!this.getProject().isDisposed()) {
            this.nativeWorkspace.commit();
        }
    }

    public NativeWorkspaceModificationTask(@NotNull Project project, @NotNull Collection<? extends NativeWorkspaceModifier> nativeWorkspaceModifiers) {
        super(project, "Resolving C/C++ Configurations", false);
        this.nativeWorkspaceModifiers = nativeWorkspaceModifiers;
        boolean bl = false;
        this.nativeModuleStats = new ArrayList();
        this.nativeWorkspace = new NativeWorkspaceImpl(project);
    }

    static {
        Companion = new Companion(null);
        logger = Logger.getInstance(NativeWorkspaceModificationTask.class);
    }

    public static final /* synthetic */ NativeWorkspaceImpl access$getNativeWorkspace$p(NativeWorkspaceModificationTask $this) {
        return $this.nativeWorkspace;
    }

    public static final /* synthetic */ List access$getNativeModuleStats$p(NativeWorkspaceModificationTask $this) {
        return $this.nativeModuleStats;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

