/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressReporter {
    private static final Logger LOG = Logger.getInstance(ProgressReporter.class);
    private final BlockingQueue<StepContext> myStepQueue = new LinkedBlockingDeque<StepContext>();
    private boolean myFinished = false;

    private synchronized void putStep(@NotNull StepContext stepContext) {
        if (this.myFinished) {
            return;
        }
        try {
            this.myStepQueue.put(stepContext);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        this.myFinished = stepContext.isFinished();
    }

    private void runProgressTask(@NotNull Project project) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Attaching native debugger", false){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    StepContext stepContext;
                    while (!(stepContext = (StepContext)ProgressReporter.this.myStepQueue.take()).isFinished()) {
                        indicator.setText(stepContext.getName());
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public ProgressReporter(final @NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressReporter.this.runProgressTask(project);
            }
        });
    }

    public void step(String stepName) {
        this.putStep(new StepContext(stepName, false));
    }

    public void finish() {
        this.putStep(new StepContext(null, true));
    }

    private static class StepContext {
        private final String myName;
        private final boolean myFinished;

        public StepContext(@Nullable String name, boolean finished) {
            this.myName = name;
            this.myFinished = finished;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        public boolean isFinished() {
            return this.myFinished;
        }
    }
}

