/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.ParcelableUtilKt;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/ParcelableQuickFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "()V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getName", "", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "getTargetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "intellij.android.kotlin.idea"})
public final class ParcelableQuickFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block0: {
            KtClass ktClass = this.getTargetClass(startElement);
            if (ktClass == null) break block0;
            ParcelableUtilKt.implementParcelable(ktClass);
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        KtClass ktClass = this.getTargetClass(startElement);
        if (ktClass == null) {
            return false;
        }
        KtClass targetClass = ktClass;
        return ParcelableUtilKt.canAddParcelable(targetClass) && !ParcelableUtilKt.isParcelize(targetClass);
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message((String)"implement.parcelable.intention.text", (Object[])new Object[0]);
    }

    private final KtClass getTargetClass(PsiElement $this$getTargetClass) {
        return (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getTargetClass, KtClass.class, (boolean)false);
    }
}

