/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.visitors;

import com.intellij.util.ArrayUtilRt;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.relations.dump.Dump;
import com.jetbrains.sourceglider.relations.dump.RelationHandle;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.visitors.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class VisitorImpl
implements Visitor {
    protected boolean myBuildDomainsMode;
    protected SymbolTable mySymbolTable;
    private Map<RelationSignature, RelationHandle> myRelationsMap = new HashMap<RelationSignature, RelationHandle>();

    protected VisitorImpl(SymbolTable symbolTable) {
        this.mySymbolTable = symbolTable;
    }

    @Override
    public String getMetaInfo(String key) {
        return null;
    }

    @Override
    public Map<String, String> getMetaInfos(String relation) {
        return new HashMap<String, String>();
    }

    public void setMyBuildDomainsMode(boolean buildDomainsMode) {
        this.myBuildDomainsMode = buildDomainsMode;
    }

    @Override
    public void init() {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void initRelations(Dump dump2) {
        for (RelationSignature signature : this.getOutputRelations()) {
            this.myRelationsMap.put(signature, dump2.addRelation(signature));
        }
    }

    public void addTuple(RelationSignature signature, Attribute ... attributes) {
        if (this.myBuildDomainsMode) {
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                Attribute attribute = attributes[i2];
                if (attribute.getType() == null) {
                    attribute.setType(signature.getType(i2));
                } else if (!attribute.getType().equals(signature.getType(i2))) {
                    throw new RuntimeException("Domain types mismatch");
                }
                this.mySymbolTable.addAttribute(attribute, true);
            }
        } else {
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (Attribute attribute : attributes) {
                attributeNames.add(attribute.getPrettyName().getText());
            }
            this.myRelationsMap.get(signature).addTuple(ArrayUtilRt.toStringArray(attributeNames));
        }
    }
}

