/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.intellij.util.ObjectUtils;
import com.jetbrains.sourceglider.ui.Messages;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class SortedArrayHelper {
    public static int getBestPosition(Comparable[] array, Comparable element) {
        int i2 = ObjectUtils.binarySearch((int)0, (int)array.length, mid -> array[mid].compareTo(element));
        return i2 >= 0 ? i2 : -i2 - 1;
    }

    public static int getPosition(Comparable[] array, Comparable element) {
        int i2 = ObjectUtils.binarySearch((int)0, (int)array.length, mid -> array[mid].compareTo(element));
        return i2 < 0 ? -1 : i2;
    }

    public static boolean containsElement(Comparable[] array, Comparable element) {
        return SortedArrayHelper.getPosition(array, element) != -1;
    }

    public static Comparable[] deleteElement(Comparable[] array, Comparable element, Class type) {
        Comparable[] result2 = (Comparable[])Array.newInstance(type, array.length - 1);
        int index = SortedArrayHelper.getPosition(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(SortedArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result2, 0, index);
        System.arraycopy(array, index + 1, result2, index, array.length - index - 1);
        return result2;
    }

    public static boolean replaceElements(Comparable[] array, Comparable oldElement, Comparable newElement) {
        int oldIndex = SortedArrayHelper.getPosition(array, oldElement);
        if (oldIndex == -1) {
            return false;
        }
        int newIndex = SortedArrayHelper.getBestPosition(array, newElement);
        if (oldIndex < newIndex) {
            if (array[newIndex].compareTo(newElement) <= 0) {
                System.arraycopy(array, oldIndex + 1, array, oldIndex, newIndex - oldIndex);
                array[newIndex] = newElement;
            } else {
                System.arraycopy(array, oldIndex + 1, array, oldIndex, newIndex - oldIndex - 1);
                array[newIndex - 1] = newElement;
            }
        } else if (oldIndex > newIndex) {
            if (array[newIndex].compareTo(newElement) >= 0) {
                System.arraycopy(array, newIndex, array, newIndex + 1, oldIndex - newIndex);
                array[newIndex] = newElement;
            } else {
                System.arraycopy(array, newIndex + 1, array, newIndex + 2, oldIndex - newIndex - 1);
                array[newIndex + 1] = newElement;
            }
        } else {
            array[newIndex] = newElement;
        }
        return true;
    }

    public static void sortAscending(Comparable[] array) {
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2 - 1].compareTo(array[i2]) <= 0) continue;
            Arrays.sort(array);
            break;
        }
    }

    public static void sortAscending(Object[] array, Comparator comparator) {
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (comparator.compare(array[i2 - 1], array[i2]) <= 0) continue;
            Arrays.sort(array, comparator);
            break;
        }
    }

    public static int[] getAscendingPermutation(Comparable[] array) {
        Object[] indices = new Integer[array.length];
        for (int i2 = 0; i2 < indices.length; ++i2) {
            indices[i2] = new Integer(i2);
        }
        SortedArrayHelper.sortAscending(indices, (arg0, arg1) -> {
            int ind1 = (Integer)arg0;
            int ind2 = (Integer)arg1;
            return array[ind1].compareTo(array[ind2]);
        });
        int[] result2 = new int[indices.length];
        for (int i3 = 0; i3 < result2.length; ++i3) {
            result2[i3] = (Integer)indices[i3];
        }
        return result2;
    }

    public static void applyPerm(Object[] array, int[] perm) {
        Object[] clone = (Object[])array.clone();
        for (int i2 = 0; i2 < perm.length; ++i2) {
            array[i2] = clone[perm[i2]];
        }
    }

    public static void applyPerm(int[] array, int[] perm) {
        int[] clone = (int[])array.clone();
        for (int i2 = 0; i2 < perm.length; ++i2) {
            array[i2] = clone[perm[i2]];
        }
    }

    public static void applyInversePerm(int[] array, int[] perm) {
        int[] clone = (int[])array.clone();
        for (int i2 = 0; i2 < perm.length; ++i2) {
            array[perm[i2]] = clone[i2];
        }
    }

    public static int[] getIDPerm(int length) {
        int[] perm = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            perm[i2] = i2;
        }
        return perm;
    }

    public static Comparable[] zipArrays(Comparable[] array1, Comparable[] array2, Class type) {
        ArrayList<Comparable> list = new ArrayList<Comparable>(3);
        int i2 = 0;
        int j = 0;
        Comparable last = new Comparable(){

            public int compareTo(Object arg0) {
                return 0;
            }
        };
        while (i2 < array1.length || j < array2.length) {
            if (j == array2.length || i2 < array1.length && array1[i2].compareTo(array2[j]) < 0) {
                Comparable a = array1[i2];
                if (!last.equals(a)) {
                    list.add(a);
                    last = a;
                }
                ++i2;
                continue;
            }
            Comparable b = array2[j];
            if (!last.equals(b)) {
                list.add(b);
                last = b;
            }
            ++j;
        }
        Comparable[] result2 = (Comparable[])Array.newInstance(type, list.size());
        for (i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = (Comparable)list.get(i2);
        }
        return result2;
    }
}

