/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.Map;

public class RelExprIf
extends RelExpr {
    private RelExpr ifRelExpr;
    private Expr ifExpr;
    private RelExpr thenBranch;
    private RelExpr elseBranch;

    public RelExprIf(RelExpr ifRelExpr, RelExpr thenBranch, RelExpr elseBranch, Context context2) {
        super(context2);
        this.ifRelExpr = ifRelExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    public RelExprIf(Expr ifExpr, RelExpr thenBranch, RelExpr elseBranch, Context context2) {
        super(context2);
        this.ifExpr = ifExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        if (this.ifExpr != null) {
            int result2 = this.ifExpr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            if (result2 != 0) {
                return this.thenBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            }
            return this.elseBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        }
        IRelation ifResult = this.ifRelExpr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation ifNotResult = ifResult.complement(threadCallback);
        IRelation thenBranchResult = this.thenBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation elseBranchResult = this.elseBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation thenResult = ifResult.unsafeIntersect(thenBranchResult, threadCallback);
        IRelation elseResult = ifNotResult.unsafeIntersect(elseBranchResult, threadCallback);
        IRelation result3 = thenResult.unsafeUnite(elseResult, threadCallback);
        ifResult.kill();
        ifNotResult.kill();
        thenBranchResult.kill();
        elseBranchResult.kill();
        thenResult.kill();
        elseResult.kill();
        return result3;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        if (this.ifRelExpr != null) {
            this.ifRelExpr.collectDomainConstraints(constraints, variablesManager);
        }
        this.thenBranch.collectDomainConstraints(constraints, variablesManager);
        this.elseBranch.collectDomainConstraints(constraints, variablesManager);
    }
}

