/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.HashSet;

public class DomainsPool {
    private HashSet<Domain> usedDomains = new HashSet();

    public void pushDomain(Domain domain) {
        this.usedDomains.add(domain);
    }

    public void popDomain(Domain domain) {
        if (!this.usedDomains.contains(domain)) {
            throw new RuntimeException(Messages.getString(DomainsPool.class.getName() + "-0"));
        }
        this.usedDomains.remove(domain);
    }

    public void assertEmpty() {
        if (!this.usedDomains.isEmpty()) {
            throw new RuntimeException(Messages.getString(DomainsPool.class.getName() + "-1"));
        }
    }

    public Domain computeBestDomain(RuntimeVariablesManager variablesManager, String domainName, DomainType domainType, DomainConstraint[] constraints) {
        Domain domain;
        int i2;
        boolean[] been = new boolean[constraints.length];
        int maxCost = -1;
        Domain bestDomain = null;
        for (i2 = 0; i2 < constraints.length; ++i2) {
            if (been[i2] || this.usedDomains.contains(domain = constraints[i2].getDomain(variablesManager))) continue;
            boolean prohibitive = false;
            int cost = 0;
            for (int j = 0; j < constraints.length; ++j) {
                if (!constraints[j].getDomain(variablesManager).equals(domain)) continue;
                been[j] = true;
                if (constraints[j].getDomainName().equals(domainName)) {
                    ++cost;
                    continue;
                }
                prohibitive = true;
                break;
            }
            if (prohibitive || cost <= maxCost) continue;
            maxCost = cost;
            bestDomain = domain;
        }
        if (maxCost > -1) {
            return bestDomain;
        }
        i2 = 0;
        while (true) {
            domain = domainType.getDomain(i2);
            boolean unique = true;
            if (!this.usedDomains.contains(domain)) {
                for (DomainConstraint constraint : constraints) {
                    if (!constraint.getDomain(variablesManager).equals(domain)) continue;
                    unique = false;
                    break;
                }
                if (unique) {
                    return domain;
                }
            }
            ++i2;
        }
    }
}

