/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.text;

import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.text.CType;
import com.jetbrains.gsa.text.SearchString;
import com.jetbrains.gsa.text.WriteString;

public class ReadString {
    public int ptr;
    public int lines;
    public String str;
    public String filename;
    public String clname;

    public ReadString(String str, String filename, String clname) {
        this.str = str;
        this.filename = filename;
        this.clname = clname;
        this.ptr = 0;
        this.lines = 0;
    }

    public ReadString(String str, ReadString copy2) {
        this.str = str;
        this.filename = copy2.filename;
        this.clname = copy2.clname;
        this.ptr = copy2.ptr;
        this.lines = copy2.lines;
    }

    public boolean findSubstr(SearchString substr) {
        int cur = 0;
        while (this.ptr < this.str.length()) {
            if (cur == substr.str.length()) {
                return true;
            }
            if (this.str.charAt(this.ptr) == '\n') {
                ++this.lines;
            }
            while (cur > 0 && substr.str.charAt(cur) != this.str.charAt(this.ptr)) {
                cur = substr.prefTable[cur];
            }
            if (substr.str.charAt(cur) == this.str.charAt(this.ptr)) {
                ++cur;
            }
            ++this.ptr;
        }
        return false;
    }

    public boolean gone() {
        return this.ptr == this.str.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadString readComments() throws GSAException {
        int comment;
        int save_lines = this.lines;
        if (this.ptr > this.str.length() - 2 || this.str.charAt(this.ptr) != '/') return null;
        if (this.str.charAt(this.ptr + 1) == '*') {
            comment = 1;
        } else {
            if (this.str.charAt(this.ptr + 1) != '/') return null;
            comment = 2;
        }
        int start = this.ptr;
        while (this.ptr < this.str.length()) {
            if (comment == 1 && this.ptr <= this.str.length() - 2 && this.str.charAt(this.ptr) == '*' && this.str.charAt(this.ptr + 1) == '/') {
                this.ptr += 2;
                break;
            }
            if (comment == 2 && this.str.charAt(this.ptr) == '\n') break;
            if (this.str.charAt(this.ptr) == '\n') {
                ++this.lines;
            }
            ++this.ptr;
        }
        if (this.gone()) {
            throw new GSAException(this, "Missed end of comments");
        }
        WriteString ans = new WriteString();
        ans.append(this.str.substring(start, this.ptr));
        ReadString linedStr = new ReadString(ans.toString(), this);
        linedStr.ptr = 0;
        linedStr.lines = save_lines;
        return linedStr;
    }

    public void skipSpace() throws GSAException {
        int oldstring;
        do {
            oldstring = this.ptr;
            if (!this.gone() && CType.isSpace(this.str.charAt(this.ptr))) {
                if (this.str.charAt(this.ptr) == '\n') {
                    ++this.lines;
                }
                ++this.ptr;
                if (this.gone()) break;
            }
            this.readComments();
        } while (this.ptr > oldstring);
    }

    public boolean nextIsID() throws GSAException {
        this.skipSpace();
        return !this.gone() && CType.isAlpha(this.str.charAt(this.ptr));
    }

    public String getID() throws GSAException {
        StringBuilder ans = new StringBuilder(0);
        this.skipSpace();
        if (this.gone() || !CType.isAlpha(this.str.charAt(this.ptr))) {
            throw new GSAException(this, "Missed ID");
        }
        while (CType.isAlNum(this.str.charAt(this.ptr))) {
            ans.append(this.str.charAt(this.ptr++));
        }
        return ans.toString();
    }

    public char getNext() {
        char ans;
        if (this.gone()) {
            return '\u0000';
        }
        if ((ans = this.str.charAt(this.ptr++)) == '\n') {
            ++this.lines;
        }
        return ans;
    }

    public char getSymbol() throws GSAException {
        char ans;
        this.skipSpace();
        if (this.gone()) {
            return '\u0000';
        }
        if ((ans = this.str.charAt(this.ptr++)) == '\n') {
            ++this.lines;
        }
        return ans;
    }

    public void readSymbol(char symbol) throws GSAException {
        if (symbol != this.getSymbol()) {
            throw new GSAException(this, "Missed symbol " + symbol);
        }
    }

    public void pushBack() {
        if (this.str.charAt(--this.ptr) == '\n') {
            --this.lines;
        }
    }

    public String readTerm() throws GSAException {
        StringBuilder ans = new StringBuilder(0);
        while (this.ptr < this.str.length() && (this.str.charAt(this.ptr) != '\"' || this.str.charAt(this.ptr - 1) == '\\')) {
            ans.append(this.str.charAt(this.ptr++));
        }
        if (this.ptr == this.str.length()) {
            throw new GSAException(this, "Missed closing \"");
        }
        ++this.ptr;
        return ans.toString();
    }

    public String toString() {
        return this.str;
    }
}

