/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Case {
    TO_UPPER(0, "To upper"){

        @Override
        @NotNull
        public String apply(@NonNls @NotNull String text) {
            return StringUtil.toUpperCase((String)text);
        }
    }
    ,
    TO_LOWER(1, "To lower"){

        @Override
        @NotNull
        public String apply(@NonNls @NotNull String text) {
            return StringUtil.toLowerCase((String)text);
        }
    }
    ,
    DO_NOT_CHANGE(2, "Do not change"){

        @Override
        @NotNull
        public String apply(@NotNull String text) {
            return text;
        }
    };

    public static final String @NotNull [] TOKEN_CASE_NAMES;
    public static final int @NotNull [] TOKEN_CASE_VALUES;
    private final int myValue;
    @NotNull
    private final String myUiDescription;

    @Nullable
    public static Case resolveByValue(int value) {
        for (int i2 = 0; i2 < Case.values().length; ++i2) {
            Case aCase = Case.values()[i2];
            if (aCase.getValue() != value) continue;
            return aCase;
        }
        return null;
    }

    private Case(int value, String uiDescription) {
        this.myValue = value;
        this.myUiDescription = uiDescription;
    }

    @NotNull
    public String getUiDescription() {
        return this.myUiDescription;
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public abstract String apply(@NotNull String var1);

    static {
        TOKEN_CASE_NAMES = new String[Case.values().length];
        TOKEN_CASE_VALUES = new int[Case.values().length];
        for (int i2 = 0; i2 < Case.values().length; ++i2) {
            Case.TOKEN_CASE_NAMES[i2] = Case.values()[i2].getUiDescription();
            Case.TOKEN_CASE_VALUES[i2] = i2;
        }
    }
}

