/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCInterner;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.compiler.CachedTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerInfoCache {
    private static final ExecutorService ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    private final OCInterner<String> myInterner = CompilerInfoCache.createDefinesInterner();
    @NotNull
    protected final Map<CompilerSettingsKey, Result> myCache = this.createCacheMap();
    @NotNull
    private final Map<CompilerSettingsKey, CompletableFuture<Result>> myInProcess = new HashMap<CompilerSettingsKey, CompletableFuture<Result>>();
    @NotNull
    protected final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ExecutorService createExecutor(int maxProcesses) {
        return AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CompilerInfoCache Pool", (int)maxProcesses);
    }

    @NotNull
    public static OCInterner<String> createDefinesInterner() {
        return new OCInterner<String>();
    }

    public static <ID extends Comparable<ID>> void flushConsoleMessages(@NotNull @NonNls String prefix, @NotNull Message.Type flushMessagesType, @NotNull MultiMap<ID, Message> messages, @NotNull BiConsumer<ID, String> messagesCollector) {
        for (Map.Entry entry : ContainerUtil.sorted((Collection)messages.entrySet(), Map.Entry.comparingByKey())) {
            List filtered = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), it -> it.getType() == flushMessagesType ? it.getText() : null);
            if (filtered.isEmpty()) continue;
            LinkedHashSet unique = new LinkedHashSet(filtered);
            String text = "\n" + prefix + ":\n\t" + StringUtil.replace((String)String.join((CharSequence)"\n", unique), (String)"\n", (String)"\n\t");
            messagesCollector.accept(entry.getKey(), text);
        }
    }

    @NotNull
    protected Map<CompilerSettingsKey, Result> createCacheMap() {
        return new ConcurrentHashMap<CompilerSettingsKey, Result>();
    }

    @NotNull
    public Result getCompilerInfo(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment) {
        CompilerSettingsKey key = CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory);
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(compilerKind, compilerExecutable, compilerWorkingDirectory, environment, TempFilesPool.INSTANCE);
        return this.getCompilerInfo(this.myInterner, compiler, lang, key, switches, ourExecutor, environment);
    }

    @NotNull
    public CompletableFuture<Result> getCompilerInfoAsync(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull Executor executor, @NotNull TempFilesPool tempFilesPool) {
        CompilerSettingsKey key = CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory);
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(compilerKind, compilerExecutable, compilerWorkingDirectory, environment, tempFilesPool);
        return this.getCompilerInfoAsync(this.myInterner, compiler, lang, key, switches, executor, environment);
    }

    @NotNull
    public static CompilerSettingsKey createCompilerKey(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory) {
        StringBuilder builder2 = new StringBuilder().append(compilerExecutable.getPath()).append("\u0000").append(compilerWorkingDirectory).append("\u0000").append(lang.getDisplayName()).append("\u0000");
        StringUtil.join(switches.getList(CidrCompilerSwitches.Format.RAW), (String)"\u0000", (StringBuilder)builder2);
        return new CompilerSettingsKey(builder2.toString());
    }

    @NotNull
    Result getCompilerInfo(@NotNull OCInterner<String> interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        CompletableFuture<Result> future = this.getCompilerInfoAsync(interner, compiler, lang, key, switches, executor, env);
        while (true) {
            ProgressManager.checkCanceled();
            try {
                return future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    CompletableFuture<Result> getCompilerInfoAsync(@NotNull OCInterner<String> interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        Result cached = this.myCache.get(key);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myCache.get(key);
            if (cached != null) {
                return CompletableFuture.completedFuture(cached);
            }
            CompletableFuture<Result> processing = this.myInProcess.get(key);
            if (processing == null) {
                processing = CompletableFuture.supplyAsync(() -> {
                    try {
                        ProgressManager.checkCanceled();
                        Result result2 = CompilerInfoCache.doCollectCompilerInfo(interner, compiler, lang, key, switches, env);
                        Object object = this.myLock;
                        synchronized (object) {
                            this.myCache.put(key, result2);
                            this.myInProcess.remove(key);
                            this.cacheDidChange();
                        }
                        return result2;
                    }
                    catch (ProcessCanceledException e) {
                        Object object = this.myLock;
                        synchronized (object) {
                            this.myInProcess.remove(key);
                        }
                        throw e;
                    }
                }, executor);
                this.myInProcess.put(key, processing);
            }
            return processing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUncleanResults() {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList keysToRemove = new ArrayList();
            this.myCache.forEach((key, result2) -> {
                CompilerInfo info = result2.getInfo();
                if (info != null && info.getCompilerExitCode() != 0) {
                    keysToRemove.add(key);
                }
            });
            for (CompilerSettingsKey key2 : keysToRemove) {
                this.myCache.remove(key2);
            }
        }
    }

    @NotNull
    private static Result doCollectCompilerInfo(@NotNull OCInterner<String> interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment env) {
        try {
            CompilerInfo info = compiler.collectInfo(lang, switches);
            HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
            for (HeadersSearchPath each : info.getHeadersSearchPaths()) {
                pathTree.addSearchPathCompacting(each);
            }
            List<HeadersSearchPath> compactedPaths = CompilerInfoCache.resolve(env, pathTree.getCompactedPaths());
            return Result.create(key, new CompilerInfo(info.getSwitches(), interner.intern(info.getDefines()), info.getFeatures(), compactedPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode()));
        }
        catch (com.intellij.execution.ExecutionException e) {
            return Result.error(key, e);
        }
    }

    @NotNull
    private static List<HeadersSearchPath> resolve(@NotNull CidrToolEnvironment env, @NotNull List<HeadersSearchPath> headersSearchPaths) {
        HostMachine host = env.getHostMachine();
        List paths = ContainerUtil.map(headersSearchPaths, p -> p.getPath());
        List<File> resolved = host.resolveAndCache(paths);
        int size = headersSearchPaths.size();
        assert (size == resolved.size());
        ArrayList<HeadersSearchPath> result2 = new ArrayList<HeadersSearchPath>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            result2.add(new HeadersSearchPath(resolved.get(i2).getPath(), headersSearchPaths.get(i2).getFlags()));
        }
        return result2;
    }

    protected void cacheDidChange() {
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator) {
        return new Session(this, indicator);
    }

    public static class Message {
        @NotNull
        public final Type type;
        @NotNull
        public final String text;

        public Message(@NotNull Type type, @NotNull String text) {
            this.type = type;
            this.text = text;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        public static enum Type {
            ERROR,
            WARNING;

        }
    }

    public static class Result {
        @NotNull
        private final CompilerSettingsKey myKey;
        @Nullable
        private final CompilerInfo myInfo;
        @Nullable
        private final Throwable myError;

        @Contract(value="_,null,null -> fail; _,!null,!null -> fail")
        private Result(@NotNull CompilerSettingsKey key, @Nullable CompilerInfo info, @Nullable Throwable error) {
            assert (info != null ^ error != null);
            this.myKey = key;
            this.myInfo = info;
            this.myError = error;
        }

        @NotNull
        @Contract(pure=true)
        public CompilerSettingsKey getKey() {
            return this.myKey;
        }

        @Nullable
        @Contract(pure=true)
        public CompilerInfo getInfo() {
            return this.myInfo;
        }

        @Nullable
        @Contract(pure=true)
        public Throwable getError() {
            return this.myError;
        }

        public static Result create(@NotNull CompilerSettingsKey key, @NotNull CompilerInfo info) {
            return new Result(key, info, null);
        }

        public static Result error(@NotNull CompilerSettingsKey key, @NotNull Throwable error) {
            return new Result(key, null, error);
        }
    }

    public static class Session<ID> {
        @NotNull
        private final CompilerInfoCache myCache;
        @NotNull
        private final ProgressIndicator myCallerProgressIndicator;
        @NotNull
        private final ProgressIndicator myJobsProgressIndicator;
        @NotNull
        private final CancelableExecutor myCancelableJobsExecutor;
        @NotNull
        private final TempFilesPool myTempFilesPool = new CachedTempFilesPool();
        @NotNull
        private final List<Pair<Future<List<Message>>, ID>> myJobs = new ArrayList<Pair<Future<List<Message>>, ID>>();
        @NotNull
        private final AtomicLong myTimeBefore = new AtomicLong(0L);
        @NotNull
        private final AtomicInteger myCompletedJobs = new AtomicInteger(0);

        private Session(@NotNull CompilerInfoCache cache, @NotNull ProgressIndicator indicator) {
            this.myCache = cache;
            this.myCallerProgressIndicator = indicator;
            this.myCallerProgressIndicator.setIndeterminate(false);
            this.myJobsProgressIndicator = new SensitiveProgressWrapper(indicator);
            this.myCancelableJobsExecutor = new CancelableExecutor(this.myJobsProgressIndicator);
        }

        public void schedule(@NotNull ID id, @NotNull OCResolveConfiguration.ModifiableModel model, @NotNull CidrToolEnvironment environment) {
            if (this.myTimeBefore.get() == 0L) {
                this.myTimeBefore.set(System.currentTimeMillis());
            }
            CompletionStage future = OCWorkspaceImplUtilKt.collectCompilerSettingsAsync(model, environment, this.myCache, this.myCancelableJobsExecutor, this.myTempFilesPool).thenApply(messages -> {
                int completedJobs = this.myCompletedJobs.incrementAndGet();
                if (!this.myCallerProgressIndicator.isIndeterminate()) {
                    this.myCallerProgressIndicator.setFraction((double)completedJobs / (double)this.myJobs.size());
                }
                return messages;
            });
            this.myJobs.add(Pair.create((Object)future, id));
        }

        public void waitForAll(@NotNull MultiMap<ID, Message> result2) {
            Throwable toReport = null;
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    result2.putValues(eachJob.second, (Collection)((Future)eachJob.first).get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ProcessCanceledException) {
                        this.myCallerProgressIndicator.cancel();
                        continue;
                    }
                    if (toReport == null) {
                        toReport = new RuntimeException(e);
                        continue;
                    }
                    toReport.addSuppressed(e);
                }
            }
            this.cleanTempFilesPool();
            if (toReport != null) {
                throw toReport;
            }
            this.myCallerProgressIndicator.checkCanceled();
            this.myCallerProgressIndicator.setFraction(1.0);
            long timeAfter = System.currentTimeMillis();
            OCWorkspaceImplUtilKt.getLOG().debug("Compiler info setup took " + StringUtil.formatDuration((long)(timeAfter - this.myTimeBefore.get())));
        }

        public void dispose() {
            this.myJobsProgressIndicator.cancel();
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    ((Future)eachJob.first).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException executionException) {
                }
            }
            this.cleanTempFilesPool();
        }

        private void cleanTempFilesPool() {
            this.myTempFilesPool.clean();
        }

        private static class CancelableExecutor
        implements Executor {
            @NotNull
            ProgressIndicator myIndicator;

            private CancelableExecutor(@NotNull ProgressIndicator indicator) {
                this.myIndicator = indicator;
            }

            @Override
            public void execute(@NotNull Runnable command) {
                ourExecutor.execute(() -> {
                    SensitiveProgressWrapper jobIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    ProgressManager.getInstance().runProcess(command, (ProgressIndicator)jobIndicator);
                    if (jobIndicator.isCanceled()) {
                        this.myIndicator.cancel();
                    }
                });
            }
        }
    }
}

