/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFeatures {
    private static final Logger LOG = Logger.getInstance(ClangFeatures.class);
    private static final String[] FEATURES_AND_EXTENSIONS = new String[]{"address_sanitizer", "assume_nonnull", "attribute_analyzer_noreturn", "attribute_availability", "attribute_availability_with_message", "attribute_availability_app_extension", "attribute_availability_with_version_underscores", "attribute_availability_tvos", "attribute_availability_watchos", "attribute_availability_with_strict", "attribute_availability_with_replacement", "attribute_availability_in_templates", "attribute_cf_returns_not_retained", "attribute_cf_returns_retained", "attribute_cf_returns_on_parameters", "attribute_deprecated_with_message", "attribute_deprecated_with_replacement", "attribute_ext_vector_type", "attribute_ns_returns_not_retained", "attribute_ns_returns_retained", "attribute_ns_consumes_self", "attribute_ns_consumed", "attribute_cf_consumed", "attribute_objc_ivar_unused", "attribute_objc_method_family", "attribute_overloadable", "attribute_unavailable_with_message", "attribute_unused_on_fields", "blocks", "c_thread_safety_attributes", "cxx_exceptions", "cxx_rtti", "enumerator_attributes", "nullability", "nullability_on_arrays", "memory_sanitizer", "thread_sanitizer", "dataflow_sanitizer", "efficiency_sanitizer", "objc_arr", "objc_arc", "objc_arc_weak", "objc_default_synthesize_properties", "objc_fixed_enum", "objc_instancetype", "objc_kindof", "objc_modules", "objc_nonfragile_abi", "objc_property_explicit_atomic", "objc_protocol_qualifier_mangling", "objc_weak_class", "ownership_holds", "ownership_returns", "ownership_takes", "objc_bool", "objc_subscripting", "objc_array_literals", "objc_dictionary_literals", "objc_boxed_expressions", "objc_boxed_nsvalue_expressions", "arc_cf_code_audited", "objc_bridge_id", "objc_bridge_id_on_typedefs", "objc_generics", "objc_generics_variance", "objc_class_property", "c_alignas", "c_alignof", "c_atomic", "c_generic_selections", "c_static_assert", "c_thread_local", "cxx_access_control_sfinae", "cxx_alias_templates", "cxx_alignas", "cxx_alignof", "cxx_atomic", "cxx_attributes", "cxx_auto_type", "cxx_constexpr", "cxx_constexpr_string_builtins", "cxx_decltype", "cxx_decltype_incomplete_return_types", "cxx_default_function_template_args", "cxx_defaulted_functions", "cxx_delegating_constructors", "cxx_deleted_functions", "cxx_explicit_conversions", "cxx_generalized_initializers", "cxx_implicit_moves", "cxx_inheriting_constructors", "cxx_inline_namespaces", "cxx_lambdas", "cxx_local_type_template_args", "cxx_nonstatic_member_init", "cxx_noexcept", "cxx_nullptr", "cxx_override_control", "cxx_range_for", "cxx_raw_string_literals", "cxx_reference_qualified_functions", "cxx_rvalue_references", "cxx_strong_enums", "cxx_static_assert", "cxx_thread_local", "cxx_trailing_return", "cxx_unicode_literals", "cxx_unrestricted_unions", "cxx_user_literals", "cxx_variadic_templates", "cxx_aggregate_nsdmi", "cxx_binary_literals", "cxx_contextual_conversions", "cxx_decltype_auto", "cxx_generic_lambdas", "cxx_init_captures", "cxx_relaxed_constexpr", "cxx_return_type_deduction", "cxx_variable_templates", "cxx_runtime_arrays", "cxx_concepts", "raw_invocation_type", "c_alignas", "c_alignof", "c_atomic", "c_generic_selections", "c_static_assert", "c_thread_local", "cxx_atomic", "cxx_deleted_functions", "cxx_explicit_conversions", "cxx_inline_namespaces", "cxx_local_type_template_args", "cxx_nonstatic_member_init", "cxx_override_control", "cxx_range_for", "cxx_reference_qualified_functions", "cxx_rvalue_references", "cxx_variadic_templates", "cxx_binary_literals", "cxx_init_captures", "cxx_variable_templates", "modules", "safe_stack", "tls"};
    private static final String[] TYPE_TRAITS = new String[]{"has_nothrow_assign", "has_nothrow_copy", "has_nothrow_constructor", "has_trivial_assign", "has_trivial_copy", "has_trivial_constructor", "has_trivial_destructor", "has_virtual_destructor", "is_abstract", "is_base_of", "is_class", "is_constructible", "is_convertible_to", "is_empty", "is_enum", "is_final", "is_literal", "is_standard_layout", "is_pod", "is_polymorphic", "is_sealed", "is_trivial", "is_trivially_assignable", "is_trivially_constructible", "is_trivially_copyable", "is_union", "underlying_type"};
    private static final String[] KNOWN_CLANG_OBJC_ATTRIBUTES = new String[]{"objc_boxable", "objc_method_family", "objc_requires_super", "objc_runtime_name", "objc_arc_weak_reference_unavailable", "objc_bridge", "objc_designated_initializer", "objc_precise_lifetime", "objc_protocol_requires_explicit_implementation", "objc_requires_property_definitions", "objc_returns_inner_pointer", "objc_root_class"};
    private static final String[] KNOWN_CLANG_APPLE_ATTRIBUTES = new String[]{"ibaction", "iboutlet", "iboutletcollection", "ns_consumed", "ns_consumed_self", "ns_returns_not_retained", "ns_returns_retained", "swift_error", "swift_name", "swift_private", "swift_wrapper"};
    private static final String[] KNOWN_CLANG_GPU_REGISTER_ATTRIBUTES = new String[]{"amdgpu_num_sgpr", "amdgpu_num_vgpr"};
    private static final String[] KNOWN_CLANG_FUNCTION_ATTRIBUTES = new String[]{"interrupt", "acquire_capability", "acquire_shared_capability", "assume_aligned", "availability", "noreturn", "carries_dependency", "enable_if", "flatten", "format", "internal_linkage", "noduplicate", "no_sanitize", "no_sanitize_address", "no_address_safety_analysis", "no_sanitize_thread", "no_sanitize_memory", "no_split_stack", "optnone", "overloadable", "__overloadable__", "release_capability", "release_shared_capability", "target", "try_acquire_capability", "try_acquire_shared_capability"};
    private static final String[] KNOWN_CLANG_VARIABLE_ATTRIBUTES = new String[]{"section", "tls_model"};
    private static final String[] KNOWN_CLANG_TYPE_ATTRIBUTES = new String[]{"align_value", "flag_enum"};
    private static final String[] KNOWN_CLANG_CALLING_CONVENTIONS_ATTRIBUTES = new String[]{"fastcall", "ms_abi", "pcs", "regparm", "stdcall", "thiscall", "vectorcall"};
    private static final String[] KNOWN_CLANG_CONSUMED_ANNOTATION_CHECKING_ATTRIBUTES = new String[]{"callable_when", "consumable", "param_typestate", "return_typestate", "set_typestate", "test_typestate"};
    private static final String[] KNOWN_CLANG_TYPE_SAFETY_CHECKING_ATTRIBUTES = new String[]{"argument_with_type_tag", "pointer_with_type_tag", "type_tag_for_datatype"};
    private static final String[] KNOWN_CLANG_TYPE_NULLABILITY_ATTRIBUTES = new String[]{"nonnull", "returns_nonnull"};
    private static final String[] KNOWN_GCC_COMMON_ATTRIBUTES = new String[]{"aligned", "deprecated", "unused", "used", "hot", "cold", "section", "weak", "packed"};
    private static final String[] KNOWN_GCC_WINDOWS_ATTRIBUTES = new String[]{"dllexport", "dllimport", "selectany", "shared"};
    private static final String[] KNOWN_GCC_X86_ATTRIBUTES = new String[]{"ms_struct", "gcc_struct", "cdecl", "fastcall", "thiscall", "ms_abi", "sysv_abi", "callee_pop_aggregate_return", "ms_hook_prologue", "regparm", "sseregparm", "force_align_arg_pointer", "stdcall", "target"};
    private static final String[] KNOWN_GCC_FUNCTION_ATTRIBUTES = new String[]{"alias", "alloc_align", "alloc_size", "always_inline", "artificial", "assume_aligned", "bnd_instrument", "bnd_legacy", "const", "constructor", "destructor", "error", "warning", "externally_visible", "flatten", "format", "format_arg", "gnu_inline", "ifunc", "interrupt", "interrupt_handler", "leaf", "malloc", "no_icf", "no_instrument_function", "no_reorder", "no_sanitize_address", "no_address_safety_analysis", "no_sanitize_thread", "no_sanitize_undefined", "no_split_stack", "noclone", "noinline", "noreturn", "nothrow", "noplt", "optimize", "pure", "returns_nonnull", "returns_twice", "sentinel", "stack_protect", "target_clones", "target", "visibility", "warn_unused_result", "weakref", "lower", "upper", "either", "reentrant", "critical", "wakeup"};
    private static final String[] KNOWN_GCC_VARIABLE_ATTRIBUTES = new String[]{"cleanup", "common", "nocommon", "mode", "tls_model", "vector_size"};
    private static final String[] KNOWN_GCC_TYPE_ATTRIBUTES = new String[]{"aligned", "bnd_variable_size", "designated_init", "may_alias", "scalar_storage_order", "transparent_union", "visibility"};
    private static final String[] KNOWN_OTHER_ATTRIBUTES = new String[]{"ext_vector_type", "__ext_vector_type__", "type_visibility", "unavailable"};
    private static final String[] BUILTINS = new String[]{"__builtin_available", "__is_target_arch", "__is_target_vendor", "__is_target_os", "__is_target_environment", "__is_target_variant_os", "__is_target_variant_environment"};
    public static final String[] SUPPORTED_BUILT_IN_TRAITS = new String[]{"__is_class", "__is_enum", "__is_union", "__is_pod", "__is_abstract"};
    private static final String[] TARGET_ARCHS = new String[]{"x86_64"};
    private static final String[] TARGET_VENDORS = new String[]{"apple"};
    private static final String[] TARGET_OSS = new String[]{"ios", "macos", "macosx", "tvos", "watchos", "driverkit"};
    private static final String[] TARGET_ENVIRONMENTS = new String[]{"simulator", "macabi"};
    private static final Set<String> ourFeatures;
    private static final Map<String, OCCompilerFeatures.Feature> ourClangIdsToCompilerFeatures;
    private static final Map<OCCompilerFeatures.Feature, String> ourCompilerFeaturesToClangIds;
    private static final Set<String> ourUnsupportedClangFeatures;
    private static final Set<String> ourAttributes;
    private static final Set<String> ourBuiltins;
    private static final Set<String> ourTargetArchs;
    private static final Set<String> ourTargetVendors;
    private static final Set<String> ourTargetOss;
    private static final Set<String> ourTargetEnvironemts;

    @NotNull
    public static Collection<String> getAllFeatures() {
        return ourFeatures;
    }

    @Nullable
    public static OCCompilerFeatures.Feature getFeatureForClangId(@NotNull String clangId) {
        return ourClangIdsToCompilerFeatures.get(clangId);
    }

    @Nullable
    public static String getClangIdForFeature(@NotNull OCCompilerFeatures.Feature feature) {
        return ourCompilerFeaturesToClangIds.get(feature);
    }

    @NotNull
    public static Set<String> getUnsupportedClangFeatures() {
        return ourUnsupportedClangFeatures;
    }

    @NotNull
    public static Collection<String> getAllAttributes() {
        return ourAttributes;
    }

    public static Set<String> getAllTargetArchs() {
        return ourTargetArchs;
    }

    public static Set<String> getAllTargetVendors() {
        return ourTargetVendors;
    }

    public static Set<String> getAllTargetOss() {
        return ourTargetOss;
    }

    public static Set<String> getAllTargetEnvironemts() {
        return ourTargetEnvironemts;
    }

    @NotNull
    public static Collection<String> getAllBuiltins() {
        return ourBuiltins;
    }

    static {
        LinkedHashSet features = new LinkedHashSet();
        Collections.addAll(features, FEATURES_AND_EXTENSIONS);
        Collections.addAll(features, TYPE_TRAITS);
        ourFeatures = Collections.unmodifiableSet(features);
        LinkedHashSet<String> unsupportedFeatures = new LinkedHashSet<String>(Arrays.asList(TYPE_TRAITS));
        for (String each : SUPPORTED_BUILT_IN_TRAITS) {
            unsupportedFeatures.remove(StringUtil.trimStart((String)each, (String)"__"));
        }
        ourBuiltins = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet((Object[])BUILTINS));
        ourTargetArchs = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet((Object[])TARGET_ARCHS));
        ourTargetVendors = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet((Object[])TARGET_VENDORS));
        ourTargetOss = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet((Object[])TARGET_OSS));
        ourTargetEnvironemts = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet((Object[])TARGET_ENVIRONMENTS));
        LinkedHashMap<OCCompilerFeatures.Feature, String> featuresToIds = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        LinkedHashMap<String, OCCompilerFeatures.Feature> idsToFeatures = new LinkedHashMap<String, OCCompilerFeatures.Feature>();
        block11: for (OCCompilerFeatures.Feature each : OCCompilerFeatures.Feature.values()) {
            String clangFeatureId;
            switch (each) {
                case MS_EXTENSIONS: 
                case GCC_AUTO_TYPE: {
                    continue block11;
                }
                case BUILTIN_AVAILABLE: {
                    clangFeatureId = "__builtin_available";
                    break;
                }
                case IS_TARGET_ARCH: {
                    clangFeatureId = "__is_target_arch";
                    break;
                }
                case IS_TARGET_VENDOR: {
                    clangFeatureId = "__is_target_vendor";
                    break;
                }
                case IS_TARGET_OS: {
                    clangFeatureId = "__is_target_os";
                    break;
                }
                case IS_TARGET_ENVIRONMENT: {
                    clangFeatureId = "__is_target_environment";
                    break;
                }
                case IS_TARGET_VARIANT_OS: {
                    clangFeatureId = "__is_target_variant_os";
                    break;
                }
                case IS_TARGET_VARIANT_ENVIRONMENT: {
                    clangFeatureId = "__is_target_variant_environment";
                    break;
                }
                default: {
                    clangFeatureId = StringUtil.toLowerCase((String)each.name());
                }
            }
            LOG.assertTrue(ourFeatures.contains(clangFeatureId) || ourBuiltins.contains(clangFeatureId), (Object)("Clang's feature id doesn't exist for " + each + " (expected id = " + clangFeatureId + ")\nPlease update ClangFeatures matcher."));
            featuresToIds.put(each, clangFeatureId);
            idsToFeatures.put(clangFeatureId, each);
            unsupportedFeatures.remove(clangFeatureId);
        }
        ourCompilerFeaturesToClangIds = Collections.unmodifiableMap(featuresToIds);
        ourClangIdsToCompilerFeatures = Collections.unmodifiableMap(idsToFeatures);
        ourUnsupportedClangFeatures = Collections.unmodifiableSet(unsupportedFeatures);
        LinkedHashSet attributes = new LinkedHashSet();
        Collections.addAll(attributes, KNOWN_CLANG_OBJC_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_APPLE_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_GPU_REGISTER_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_FUNCTION_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_VARIABLE_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_TYPE_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_CALLING_CONVENTIONS_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_CONSUMED_ANNOTATION_CHECKING_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_TYPE_SAFETY_CHECKING_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_CLANG_TYPE_NULLABILITY_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_COMMON_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_WINDOWS_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_X86_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_FUNCTION_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_VARIABLE_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_GCC_TYPE_ATTRIBUTES);
        Collections.addAll(attributes, KNOWN_OTHER_ATTRIBUTES);
        ourAttributes = Collections.unmodifiableSet(attributes);
    }

    public static enum Warnings implements Warning
    {
        UNUSED_VARIABLE("unused-variable", new Warnings[0]),
        UNUSED_LABEL("unused-label", new Warnings[0]),
        UNUSED_LAMBDA_CAPTURE("unused-lambda-capture", new Warnings[0]),
        SHADOW_FIELD_IN_CTOR_MODIFIED("shadow-field-in-constructor-modified", new Warnings[0]),
        SHADOW_IVAR("shadow-ivar", new Warnings[0]),
        SHADOW("shadow", SHADOW_FIELD_IN_CTOR_MODIFIED, SHADOW_IVAR),
        IMPLICIT_FUNCTION_DECLARATION("implicit-function-declaration", new Warnings[0]),
        SWITCH("switch", new Warnings[0]),
        UNINITIALIZED("uninitialized", new Warnings[0]),
        INFINITE_RECURSION("infinite-recursion", new Warnings[0]),
        BITWISE_OP_PARENTHESES("bitwise-op-parentheses", new Warnings[0]),
        DANGLING_ELSE("dangling-else", new Warnings[0]),
        LOGICAL_NOT_PARENTHESES("logical-not-parentheses", new Warnings[0]),
        LOGICAL_OP_PARENTHESES("logical-op-parentheses", new Warnings[0]),
        OVERLOADED_SHIFT_OP_PARENTHESES("overloaded-shift-op-parentheses", new Warnings[0]),
        PARENTHESES_EQUALITY("parentheses-equality", new Warnings[0]),
        SHIFT_OP_PARENTHESES("shift-op-parentheses", new Warnings[0]),
        PARENTHESES("parentheses", BITWISE_OP_PARENTHESES, DANGLING_ELSE, LOGICAL_NOT_PARENTHESES, LOGICAL_OP_PARENTHESES, OVERLOADED_SHIFT_OP_PARENTHESES, PARENTHESES_EQUALITY, SHIFT_OP_PARENTHESES);

        @NotNull
        private final String myOption;
        @NotNull
        private final Set<Warning> myAlsoControlledOptions;

        private Warnings(String option, Warnings ... alsoControlled) {
            this.myOption = option;
            if (alsoControlled != null && alsoControlled.length > 0) {
                TreeSet<Warning> warnings = new TreeSet<Warning>(Comparator.comparing(Warning::getName));
                warnings.addAll(Arrays.asList(alsoControlled));
                this.myAlsoControlledOptions = Collections.unmodifiableSet(warnings);
            } else {
                this.myAlsoControlledOptions = Collections.emptySet();
            }
        }

        @Override
        @NotNull
        public String getName() {
            return this.myOption;
        }

        @Override
        @NotNull
        public String getEnabled(boolean asError) {
            return "-W" + (asError ? "error=" : "") + this.getName();
        }

        @Override
        @NotNull
        public String getDisabled() {
            return "-Wno-" + this.getName();
        }

        @Override
        @NotNull
        public Set<Warning> getAlsoControlledByThis() {
            return this.myAlsoControlledOptions;
        }

        @Override
        @NotNull
        public List<String> getEnabledOnlyThis(boolean asError) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getEnabled(asError));
            for (Warning warning : this.getAlsoControlledByThis()) {
                args.add(warning.getDisabled());
            }
            return args;
        }

        @Override
        @NotNull
        public List<String> getDisabledOnlyThis() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getDisabled());
            for (Warning warning : this.getAlsoControlledByThis()) {
                args.add(warning.getEnabled(false));
            }
            return args;
        }
    }

    public static interface Warning {
        @NotNull
        public String getName();

        @NotNull
        public String getEnabled(boolean var1);

        @NotNull
        public String getDisabled();

        @NotNull
        public Set<Warning> getAlsoControlledByThis();

        @NotNull
        public List<String> getEnabledOnlyThis(boolean var1);

        @NotNull
        public List<String> getDisabledOnlyThis();
    }
}

