/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.workspace.compiler.BaseTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.IOException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

public class CachedTempFilesPool
implements TempFilesPool {
    @NotNull
    private final ConcurrentMap<String, Path> myTempFileCache = new ConcurrentHashMap<String, Path>();

    @Override
    @NotNull
    public Path writeToTempFile(@NotNull HostMachine host, @NotNull String fileText, @NotNull Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        return this.getOrCreateTempFile(host, fileText, tmpDir, prefix, suffix);
    }

    @NotNull
    private Path getOrCreateTempFile(@NotNull HostMachine host, @NotNull String fileText, @NotNull Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        MessageDigest digest = DigestUtil.md5();
        digest.update(fileText.getBytes(Charsets.UTF_8));
        digest.update(suffix.getBytes(Charsets.UTF_8));
        digest.update(host.getHostId().getBytes(Charsets.UTF_8));
        String key = StringUtil.toHexString((byte[])digest.digest());
        Path result2 = (Path)this.myTempFileCache.get(key);
        if (result2 != null) {
            return result2;
        }
        Path tempFile = BaseTempFilesPool.createTempFile(fileText, tmpDir, prefix, suffix);
        Path prevValue = this.myTempFileCache.putIfAbsent(key, tempFile);
        if (prevValue == null) {
            return tempFile;
        }
        PathKt.delete((Path)tempFile);
        return prevValue;
    }

    @Override
    public void delete(@NotNull Path file2) {
    }

    @Override
    public void clean() {
        ArrayList files = new ArrayList(this.myTempFileCache.values());
        this.myTempFileCache.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (Path value : files) {
                PathKt.delete((Path)value);
            }
        });
    }
}

