/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCLValueUtil {
    public static boolean isLValue(@NotNull OCExpression expression) {
        LValueChecker checker = new LValueChecker();
        checker.process(expression);
        return checker.isLValue();
    }

    public static boolean isAssignmentLHS(@NotNull OCExpression expression) {
        LValueChecker checker = new LValueChecker();
        checker.process(expression);
        return checker.isAssignmentLHS();
    }

    private static class LValueChecker {
        private boolean myLValue = false;
        private boolean myAssignmentLHS = false;

        LValueChecker() {
        }

        public boolean isLValue() {
            return this.myLValue;
        }

        public boolean isAssignmentLHS() {
            return this.myAssignmentLHS;
        }

        public void process(@NotNull OCExpression expression) {
            PsiElement parent = (expression = this.getTopmostLValueParent(expression)).getParent();
            if (parent instanceof OCAssignmentExpression) {
                this.myAssignmentLHS = ((OCAssignmentExpression)parent).getReceiverExpression() == expression;
            } else if (parent instanceof OCPostfixExpression) {
                OCElementType sign = ((OCPostfixExpression)parent).getOperationSign();
                this.myAssignmentLHS = sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
            } else if (parent instanceof OCPrefixExpression) {
                OCElementType sign = ((OCPrefixExpression)parent).getOperationSign();
                this.myAssignmentLHS = sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
            }
            this.myLValue |= this.myAssignmentLHS;
        }

        @NotNull
        private OCExpression getTopmostLValueParent(@NotNull OCExpression expression) {
            OCExpression parentExpr;
            OCExpression unparen = OCParenthesesUtils.topmostParenthesized(expression);
            PsiElement parent = unparen.getParent();
            while (parent instanceof OCExpression && (LValueChecker.isAddressOperator(parentExpr = (OCExpression)parent) || LValueChecker.isDereference(parentExpr) || LValueChecker.isBodyOfConditionalExpr(unparen, parentExpr))) {
                this.myLValue = LValueChecker.isAddressOperator(parentExpr) || LValueChecker.isDereference(parentExpr);
                unparen = OCParenthesesUtils.topmostParenthesized(parentExpr);
                parent = unparen.getParent();
            }
            return unparen;
        }

        private static boolean isAddressOperator(@NotNull OCExpression expression) {
            return expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).isGetAddress();
        }

        private static boolean isDereference(@NotNull OCExpression expression) {
            return expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCTokenTypes.MUL;
        }

        private static boolean isBodyOfConditionalExpr(@NotNull OCExpression expression, @NotNull OCExpression parentExpression) {
            if (!(parentExpression instanceof OCConditionalExpression)) {
                return false;
            }
            OCConditionalExpression conditionalExpression = (OCConditionalExpression)parentExpression;
            return conditionalExpression.getPositiveExpression(true) == expression || conditionalExpression.getNegativeExpression() == expression;
        }
    }
}

